/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Base64;
import sun.security.util.Length;

public final class AsymmetricKeyCredential {
    public static final int MIN_KEYSIZE_IN_BITS = 2048;
    private final String clientId;
    private final PrivateKey key;
    private final X509Certificate publicCertificate;

    private AsymmetricKeyCredential(String clientId, PrivateKey key, X509Certificate publicCertificate) {
        if (StringHelper.isBlank(clientId)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        if (key == null) {
            throw new NullPointerException("PrivateKey is null or empty");
        }
        this.clientId = clientId;
        this.key = key;
        if (key instanceof RSAPrivateKey) {
            if (((RSAPrivateKey)key).getModulus().bitLength() < 2048) {
                throw new IllegalArgumentException("certificate key size must be at least 2048");
            }
        } else if ("sun.security.mscapi.RSAPrivateKey".equals(key.getClass().getName())) {
            if (((Length)((Object)key)).length() < 2048) {
                throw new IllegalArgumentException("certificate key size must be at least 2048");
            }
        } else {
            throw new IllegalArgumentException("certificate key must be an instance of java.security.interfaces.RSAPrivateKey or sun.security.mscapi.RSAPrivateKey");
        }
        this.publicCertificate = publicCertificate;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getPublicCertificateHash() throws CertificateEncodingException, NoSuchAlgorithmException {
        return Base64.encodeBase64String(AsymmetricKeyCredential.getHash(this.publicCertificate.getEncoded()));
    }

    public String getPublicCertificate() throws CertificateEncodingException, NoSuchAlgorithmException {
        return Base64.encodeBase64String(this.publicCertificate.getEncoded());
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public static AsymmetricKeyCredential create(String clientId, InputStream pkcs12Certificate, String password) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore keystore = KeyStore.getInstance("PKCS12", "SunJSSE");
        keystore.load(pkcs12Certificate, password.toCharArray());
        Enumeration<String> aliases = keystore.aliases();
        String alias = aliases.nextElement();
        PrivateKey key = (PrivateKey)keystore.getKey(alias, password.toCharArray());
        X509Certificate publicCertificate = (X509Certificate)keystore.getCertificate(alias);
        return AsymmetricKeyCredential.create(clientId, key, publicCertificate);
    }

    public static AsymmetricKeyCredential create(String clientId, PrivateKey key, X509Certificate publicCertificate) {
        return new AsymmetricKeyCredential(clientId, key, publicCertificate);
    }

    private static byte[] getHash(byte[] inputBytes) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(inputBytes);
        return md.digest();
    }
}

