/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ConstraintViolationException;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.ucanaccess.commands.AutoNumberAction;
import net.ucanaccess.commands.BlobAction;
import net.ucanaccess.commands.DeleteCommand;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.complex.Attachment;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.complex.SingleValue;
import net.ucanaccess.complex.Version;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.DBReferenceSingleton;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.triggers.AutoNumberManager;

public class InsertCommand
implements ICommand {
    private Database dbIO;
    private String execId;
    private Object[] newRow;
    private Table table;
    private String tableName;

    public InsertCommand(String _tableName, Database _dbIo, Object[] _newRow, String _execId) {
        this.tableName = _tableName;
        this.dbIO = _dbIo;
        this.newRow = _newRow;
        this.execId = _execId;
    }

    public InsertCommand(Table _table, Object[] _newRow, String _execId) {
        this.table = _table;
        this.tableName = _table.getName();
        this.newRow = _newRow;
        this.execId = _execId;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public ICommand.TYPES getType() {
        return ICommand.TYPES.INSERT;
    }

    private Object[] mementoRow() {
        Object[] clone = new Object[this.newRow.length];
        int i = 0;
        Object[] objectArray = this.newRow;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            Object obj;
            clone[i] = obj = objectArray[j];
            ++i;
        }
        return clone;
    }

    private void initComplex() {
        for (int i = 0; i < this.newRow.length; ++i) {
            if (!(this.newRow[i] instanceof ComplexBase)) continue;
            this.newRow[i] = Column.AUTO_NUMBER;
        }
    }

    public void insertRow(Table _table, Object[] _row) throws IOException {
        try {
            _table.addRow(this.newRow);
        }
        catch (ConstraintViolationException e) {
            List<? extends Column> lc = _table.getColumns();
            boolean retry = false;
            for (Column column : lc) {
                if (!column.isAutoNumber()) continue;
                retry = true;
                break;
            }
            if (!retry) {
                throw e;
            }
            Database db = _table.getDatabase();
            File file = db.getFile();
            DBReferenceSingleton dbsin = DBReferenceSingleton.getInstance();
            DBReference ref = dbsin.getReference(file);
            ref.reloadDbIO();
            this.dbIO = ref.getDbIO();
            _table = this.dbIO.getTable(this.tableName);
            _table.addRow(this.newRow);
        }
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        try {
            AutoNumberAction ana = null;
            if (this.table == null) {
                this.table = this.dbIO.getTable(this.tableName);
            }
            Object[] memento = this.mementoRow();
            this.initComplex();
            int j = 0;
            List<? extends Column> lc = this.table.getColumns();
            if (this.table.getDatabase().getColumnOrder().equals((Object)Table.ColumnOrder.DISPLAY)) {
                Object[] newRowReorded = new Object[this.newRow.length];
                Column[] columnArray = new Column[this.newRow.length];
                for (Column column : this.table.getColumns()) {
                    newRowReorded[column.getColumnIndex()] = this.newRow[j];
                    memento[column.getColumnIndex()] = this.newRow[j];
                    columnArray[column.getColumnIndex()] = column;
                    ++j;
                }
                this.newRow = newRowReorded;
                lc = Arrays.asList(columnArray);
            }
            this.insertRow(this.table, this.newRow);
            j = 0;
            for (Column column : lc) {
                ColumnImpl cl = (ColumnImpl)column;
                if (cl.isAutoNumber() && !memento[j].equals(this.newRow[j]) && !cl.getAutoNumberGenerator().getType().equals((Object)DataType.COMPLEX_TYPE)) {
                    if (cl.getAutoNumberGenerator().getType().equals((Object)DataType.LONG)) {
                        AutoNumberManager.reset(cl, (Integer)this.newRow[j]);
                    }
                    ana = new AutoNumberAction(this.table, memento, this.newRow);
                }
                if (cl.getType() == DataType.COMPLEX_TYPE) {
                    ComplexBase[] vs;
                    ComplexValueForeignKey complexValueForeignKey = (ComplexValueForeignKey)cl.getRowValue(this.newRow);
                    if (memento[j] instanceof Attachment[]) {
                        Attachment[] atcs = (Attachment[])memento[j];
                        for (ComplexBase complexBase : atcs) {
                            complexValueForeignKey.addAttachment(((Attachment)complexBase).getUrl(), ((Attachment)complexBase).getName(), ((Attachment)complexBase).getType(), ((Attachment)complexBase).getData(), ((Attachment)complexBase).getTimeStamp(), ((Attachment)complexBase).getFlags());
                        }
                    } else if (memento[j] instanceof SingleValue[]) {
                        vs = (SingleValue[])memento[j];
                        for (ComplexBase complexBase : vs) {
                            complexValueForeignKey.addMultiValue(((SingleValue)complexBase).getValue());
                        }
                    } else if (memento[j] instanceof Version[]) {
                        vs = (Version[])memento[j];
                        for (ComplexBase complexBase : vs) {
                            complexValueForeignKey.addVersion(((Version)complexBase).getValue(), ((Version)complexBase).getModifiedDate());
                        }
                    }
                }
                ++j;
            }
            BlobAction ba = new BlobAction(this.table, this.newRow);
            ba.doAction(this);
            return ana;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        if (this.table != null) {
            DeleteCommand dc = new DeleteCommand(this.table, new Persist2Jet().getRowPattern(this.newRow, this.table), this.execId);
            return dc.persist();
        }
        return null;
    }
}

