/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateTableRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<AttributeDefinition> attributeDefinitions;
    private String tableName;
    private ProvisionedThroughput provisionedThroughput;
    private List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;
    private StreamSpecification streamSpecification;

    public UpdateTableRequest() {
    }

    public UpdateTableRequest(String tableName, ProvisionedThroughput provisionedThroughput) {
        this.setTableName(tableName);
        this.setProvisionedThroughput(provisionedThroughput);
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null) {
            this.attributeDefinitions = null;
            return;
        }
        this.attributeDefinitions = new ArrayList<AttributeDefinition>(attributeDefinitions);
    }

    public UpdateTableRequest withAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
        if (this.attributeDefinitions == null) {
            this.setAttributeDefinitions(new ArrayList<AttributeDefinition>(attributeDefinitions.length));
        }
        for (AttributeDefinition ele : attributeDefinitions) {
            this.attributeDefinitions.add(ele);
        }
        return this;
    }

    public UpdateTableRequest withAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        this.setAttributeDefinitions(attributeDefinitions);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public UpdateTableRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public UpdateTableRequest withProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.setProvisionedThroughput(provisionedThroughput);
        return this;
    }

    public List<GlobalSecondaryIndexUpdate> getGlobalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates;
    }

    public void setGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
        if (globalSecondaryIndexUpdates == null) {
            this.globalSecondaryIndexUpdates = null;
            return;
        }
        this.globalSecondaryIndexUpdates = new ArrayList<GlobalSecondaryIndexUpdate>(globalSecondaryIndexUpdates);
    }

    public UpdateTableRequest withGlobalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... globalSecondaryIndexUpdates) {
        if (this.globalSecondaryIndexUpdates == null) {
            this.setGlobalSecondaryIndexUpdates(new ArrayList<GlobalSecondaryIndexUpdate>(globalSecondaryIndexUpdates.length));
        }
        for (GlobalSecondaryIndexUpdate ele : globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates.add(ele);
        }
        return this;
    }

    public UpdateTableRequest withGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
        this.setGlobalSecondaryIndexUpdates(globalSecondaryIndexUpdates);
        return this;
    }

    public void setStreamSpecification(StreamSpecification streamSpecification) {
        this.streamSpecification = streamSpecification;
    }

    public StreamSpecification getStreamSpecification() {
        return this.streamSpecification;
    }

    public UpdateTableRequest withStreamSpecification(StreamSpecification streamSpecification) {
        this.setStreamSpecification(streamSpecification);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(this.getAttributeDefinitions()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getProvisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.getProvisionedThroughput()).append(",");
        }
        if (this.getGlobalSecondaryIndexUpdates() != null) {
            sb.append("GlobalSecondaryIndexUpdates: ").append(this.getGlobalSecondaryIndexUpdates()).append(",");
        }
        if (this.getStreamSpecification() != null) {
            sb.append("StreamSpecification: ").append(this.getStreamSpecification());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)obj;
        if (other.getAttributeDefinitions() == null ^ this.getAttributeDefinitions() == null) {
            return false;
        }
        if (other.getAttributeDefinitions() != null && !other.getAttributeDefinitions().equals(this.getAttributeDefinitions())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (other.getProvisionedThroughput() != null && !other.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (other.getGlobalSecondaryIndexUpdates() == null ^ this.getGlobalSecondaryIndexUpdates() == null) {
            return false;
        }
        if (other.getGlobalSecondaryIndexUpdates() != null && !other.getGlobalSecondaryIndexUpdates().equals(this.getGlobalSecondaryIndexUpdates())) {
            return false;
        }
        if (other.getStreamSpecification() == null ^ this.getStreamSpecification() == null) {
            return false;
        }
        return other.getStreamSpecification() == null || other.getStreamSpecification().equals(this.getStreamSpecification());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeDefinitions() == null ? 0 : this.getAttributeDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalSecondaryIndexUpdates() == null ? 0 : this.getGlobalSecondaryIndexUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getStreamSpecification() == null ? 0 : this.getStreamSpecification().hashCode());
        return hashCode;
    }

    @Override
    public UpdateTableRequest clone() {
        return (UpdateTableRequest)super.clone();
    }
}

