/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.tds.Iana;
import com.sybase.jdbc4.tds.ParamFormatToken;
import com.sybase.jdbc4.tds.Slurp;
import com.sybase.jdbc4.tds.SrvAttentionException;
import com.sybase.jdbc4.tds.SrvBulkException;
import com.sybase.jdbc4.tds.SrvCapabilityToken;
import com.sybase.jdbc4.tds.SrvCurCloseToken;
import com.sybase.jdbc4.tds.SrvCurDeclare2Token;
import com.sybase.jdbc4.tds.SrvCurDeclare3Token;
import com.sybase.jdbc4.tds.SrvCurDeclareToken;
import com.sybase.jdbc4.tds.SrvCurDeleteToken;
import com.sybase.jdbc4.tds.SrvCurFetchToken;
import com.sybase.jdbc4.tds.SrvCurInfo3Token;
import com.sybase.jdbc4.tds.SrvCurInfoToken;
import com.sybase.jdbc4.tds.SrvCurOpenToken;
import com.sybase.jdbc4.tds.SrvCurUpdateToken;
import com.sybase.jdbc4.tds.SrvDataInputStream;
import com.sybase.jdbc4.tds.SrvDataOutputStream;
import com.sybase.jdbc4.tds.SrvDbrpcToken;
import com.sybase.jdbc4.tds.SrvDoneInProcToken;
import com.sybase.jdbc4.tds.SrvDoneToken;
import com.sybase.jdbc4.tds.SrvDumpInputStream;
import com.sybase.jdbc4.tds.SrvDumpOutputStream;
import com.sybase.jdbc4.tds.SrvDynamic2Token;
import com.sybase.jdbc4.tds.SrvEedToken;
import com.sybase.jdbc4.tds.SrvEventListener;
import com.sybase.jdbc4.tds.SrvEventToken;
import com.sybase.jdbc4.tds.SrvFormatToken;
import com.sybase.jdbc4.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc4.tds.SrvKeyToken;
import com.sybase.jdbc4.tds.SrvLanguageToken;
import com.sybase.jdbc4.tds.SrvLoginToken;
import com.sybase.jdbc4.tds.SrvLogoutToken;
import com.sybase.jdbc4.tds.SrvMsgToken;
import com.sybase.jdbc4.tds.SrvParamFormat2Token;
import com.sybase.jdbc4.tds.SrvParamFormatToken;
import com.sybase.jdbc4.tds.SrvParamsToken;
import com.sybase.jdbc4.tds.SrvPassthroughLanguageToken;
import com.sybase.jdbc4.tds.SrvProtocolException;
import com.sybase.jdbc4.tds.SrvRequestListener2;
import com.sybase.jdbc4.tds.SrvTypeException;
import com.sybase.jdbc4.tds.SrvUnknownPacketException;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.tds.Token;
import com.sybase.jdbc4.utils.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.security.auth.Subject;

public class SrvSession
implements Runnable {
    private OutputStream _rawOut = null;
    private SrvDataInputStream _tdsin = null;
    private SrvDataOutputStream _tdsout = null;
    private Socket _srvSocket = null;
    private SrvDataOutputStream _asyncNotif = null;
    private Vector _listeners = new Vector();
    protected Vector _events = new Vector();
    protected SrvCapabilityToken _cap = null;
    private SrvLoginToken _login = null;
    private volatile boolean _running = false;
    private String _encoding = System.getProperty("file.encoding");
    protected boolean _encodingChanged = false;
    private Hashtable _sessionData = new Hashtable();
    protected Hashtable _cursors = new Hashtable();
    public Subject _subject = null;

    public SrvSession(InputStream inputStream, OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
        try {
            this._rawOut = bl2 ? new SrvDumpOutputStream(outputStream) : outputStream;
            this._tdsout = new SrvDataOutputStream(this._rawOut);
            this._tdsin = bl ? new SrvDataInputStream(new SrvDumpInputStream(inputStream)) : new SrvDataInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public SrvSession(Socket socket, InputStream inputStream, OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
        this(inputStream, outputStream, bl, bl2);
        this._srvSocket = socket;
    }

    @Override
    public void run() {
        try {
            this.login();
        }
        catch (IOException iOException) {
            this.fireEvent(iOException, null);
            return;
        }
        catch (Exception exception) {
            this.fireEvent(exception, null);
            return;
        }
        if (this._subject != null) {
            Subject.doAs(this._subject, new PrivilegedAction(){

                public Object run() {
                    SrvSession.this.processRequests();
                    return null;
                }
            });
        } else {
            this.processRequests();
        }
    }

    private void processRequests() {
        this._running = true;
        while (this._running) {
            try {
                this.fireEvent(this.receive(), null);
            }
            catch (SrvAttentionException srvAttentionException) {
                this.fireEvent(null, null);
            }
            catch (SrvBulkException srvBulkException) {
                this.fireEvent(srvBulkException, null);
                try {
                    while (this._tdsin.read() != -1) {
                    }
                    this._tdsin.bulkDone();
                }
                catch (IOException iOException) {
                    this.fireEvent(iOException, null);
                }
            }
            catch (SocketException socketException) {
                this._listeners.removeElement(this);
                this.close();
                break;
            }
            catch (IOException iOException) {
                this.fireEvent(iOException, null);
            }
            Thread.yield();
        }
    }

    public Token receive() throws IOException, SrvAttentionException, SrvBulkException {
        int n = 0;
        try {
            n = this._tdsin.readUnsignedByte();
            if (this._tdsin.getCurrentPDUType() == 1) {
                SrvPassthroughLanguageToken srvPassthroughLanguageToken = new SrvPassthroughLanguageToken(n, this._tdsin);
                return srvPassthroughLanguageToken;
            }
        }
        catch (SrvAttentionException srvAttentionException) {
            this._tdsin.flush();
            throw srvAttentionException;
        }
        Token token = null;
        switch (n) {
            case 101: {
                token = new SrvMsgToken(this._tdsin);
                break;
            }
            case 33: {
                token = new SrvLanguageToken(this._tdsin);
                break;
            }
            case 113: {
                token = new SrvLogoutToken(this._tdsin);
                break;
            }
            case 226: {
                try {
                    token = new SrvCapabilityToken(this._tdsin);
                }
                catch (SQLException sQLException) {
                    ErrorMessage.raiseIOException(sQLException.getSQLState());
                }
                break;
            }
            case 230: {
                token = new SrvDbrpcToken(this._tdsin);
                break;
            }
            case 236: {
                token = new SrvParamFormatToken(this._tdsin);
                break;
            }
            case 32: {
                token = new SrvParamFormat2Token(this._tdsin);
                break;
            }
            case 215: {
                token = new SrvParamsToken(this._tdsin);
                break;
            }
            case 128: {
                token = new SrvCurCloseToken(this._tdsin);
                break;
            }
            case 35: {
                token = new SrvCurDeclare2Token(this._tdsin);
                break;
            }
            case 16: {
                token = new SrvCurDeclare3Token(this._tdsin);
                break;
            }
            case 131: {
                token = new SrvCurInfoToken(this._tdsin);
                break;
            }
            case 136: {
                token = new SrvCurInfo3Token(this._tdsin);
                break;
            }
            case 132: {
                token = new SrvCurOpenToken(this._tdsin);
                break;
            }
            case 130: {
                token = new SrvCurFetchToken(this._tdsin);
                break;
            }
            case 133: {
                token = new SrvCurUpdateToken(this._tdsin);
                break;
            }
            case 129: {
                token = new SrvCurDeleteToken(this._tdsin);
                break;
            }
            case 202: {
                token = new SrvKeyToken(this._tdsin);
                break;
            }
            case 98: {
                token = new SrvDynamic2Token(this._tdsin);
                break;
            }
            default: {
                Slurp slurp = new Slurp(this._tdsin, n);
                throw new SrvUnknownPacketException("Received unknown or unhandled TDS token type: 0x" + Integer.toHexString(n));
            }
        }
        return token;
    }

    public void addSrvRequestListener(SrvRequestListener2 srvRequestListener2) {
        this._listeners.addElement(srvRequestListener2);
    }

    public void removeSrvRequestListener(SrvRequestListener2 srvRequestListener2) {
        this._listeners.removeElement(srvRequestListener2);
    }

    public void send(Token token) throws IOException {
        this.send(this._tdsout, token);
    }

    public void send(Token token, boolean bl) throws IOException {
        token.send(this._tdsout);
        if (bl) {
            this._tdsout.flush(true);
        }
    }

    public void send(SrvDataOutputStream srvDataOutputStream, Token token) throws IOException {
        token.send(srvDataOutputStream);
        if (token instanceof SrvDoneToken && ((SrvDoneToken)token).getFinal()) {
            srvDataOutputStream.flush(true);
        }
    }

    public boolean inputStreamAvailable() {
        try {
            if (this._tdsin.available() > 0) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void sendAttention() throws IOException {
        this._tdsout.setAttention();
        this._tdsout.flush(true);
    }

    public synchronized void close() {
        try {
            this._running = false;
            if (this._tdsout != null) {
                this._tdsout.flush();
                this._tdsout.close();
                this._tdsout = null;
            }
            if (this._tdsin != null) {
                this._tdsin.flush();
                this._tdsin.close();
                this._tdsin = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (true) {
                SrvEventListener srvEventListener = (SrvEventListener)this._events.elementAt(0);
                srvEventListener.close();
                this._events.removeElementAt(0);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public SrvCapabilityToken getClientCapability() {
        return this._cap;
    }

    public SrvLoginToken getLogin() {
        return this._login;
    }

    public void login() throws IOException {
        Object object;
        this._login = new SrvLoginToken(this._tdsin);
        this._tdsin.setBigEndian(this._login.getBigEndian());
        this._tdsout.setBigEndian(this._login.getBigEndian());
        if (this._login.getCharset() == null || this._login.getCharset().equals("")) {
            this._encodingChanged = true;
            this._login._charset = Iana.reverseLookupIana(this._encoding);
            if (this._login._charset.equals("UnsupportedCharset")) {
                this._login._charset = "iso_1";
            }
        }
        boolean bl = false;
        try {
            object = Iana.lookupIana(this._login.getCharset());
            this._tdsin.setEncoding((String)object);
            this._tdsout.setEncoding((String)object);
            this._encoding = object;
        }
        catch (Exception exception) {
            this._encodingChanged = true;
            try {
                this._tdsin.setEncoding(this._encoding);
                this._tdsout.setEncoding(this._encoding);
            }
            catch (Exception exception2) {
                throw new IOException("Problems negotiating PDU protocol: " + exception2);
            }
            bl = true;
        }
        this.receiveClientCapabilities();
        this._tdsin.setPacketSize(this._login.getPacketSize());
        this._tdsout.setPacketSize(this._login.getPacketSize());
        if (bl) {
            object = new SrvEedToken(2409, 0, 0, "01ZZZ", 0, " Cannot find the requested character set in Syscharsets:  name = '" + this._login.getCharset() + "'. No conversions will be done.", "Unknown", null, 0);
            this.send((Token)object);
        }
        this.fireEvent(this._login, null);
    }

    protected void receiveClientCapabilities() throws IOException, SrvAttentionException, SrvBulkException {
        try {
            this._cap = (SrvCapabilityToken)this.receive();
            this._cap.setDefaultServerCapabilities();
        }
        catch (ClassCastException classCastException) {
            throw new SrvProtocolException("Did not get SrvCapabilityToken for connection request");
        }
    }

    protected void fireEvent(Object object, Object object2) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            SrvRequestListener2 srvRequestListener2 = (SrvRequestListener2)this._listeners.elementAt(i);
            if (object == null) {
                srvRequestListener2.attention(this);
                continue;
            }
            if (object instanceof SrvPassthroughLanguageToken) {
                srvRequestListener2.passthroughLanguage(this, (SrvPassthroughLanguageToken)object);
                continue;
            }
            if (object instanceof SrvLoginToken) {
                srvRequestListener2.connect(this, (SrvLoginToken)object);
                continue;
            }
            if (object instanceof SrvLanguageToken) {
                srvRequestListener2.language(this, (SrvLanguageToken)object);
                continue;
            }
            if (object instanceof SrvDbrpcToken) {
                srvRequestListener2.rpc(this, (SrvDbrpcToken)object);
                continue;
            }
            if (object instanceof SrvCurCloseToken) {
                srvRequestListener2.closeCursor(this, (SrvCurCloseToken)object);
                continue;
            }
            if (object instanceof SrvCurDeclareToken) {
                try {
                    if (this._tdsin.available() != 0) {
                        srvRequestListener2.declareCursor(this, (SrvCurDeclareToken)object, true);
                        continue;
                    }
                    srvRequestListener2.declareCursor(this, (SrvCurDeclareToken)object, false);
                }
                catch (IOException iOException) {}
                continue;
            }
            if (object instanceof SrvCurInfoToken || object instanceof SrvCurInfo3Token) {
                try {
                    if (this._tdsin.available() != 0) {
                        srvRequestListener2.processCurInfo(this, (SrvCurInfoToken)object, true);
                        continue;
                    }
                    srvRequestListener2.processCurInfo(this, (SrvCurInfoToken)object, false);
                }
                catch (IOException iOException) {}
                continue;
            }
            if (object instanceof SrvCurOpenToken) {
                try {
                    if (this._tdsin.available() != 0) {
                        srvRequestListener2.openCursor(this, (SrvCurOpenToken)object, true);
                        continue;
                    }
                    srvRequestListener2.openCursor(this, (SrvCurOpenToken)object, false);
                }
                catch (IOException iOException) {}
                continue;
            }
            if (object instanceof SrvCurFetchToken) {
                srvRequestListener2.cursorFetch(this, (SrvCurFetchToken)object);
                continue;
            }
            if (object instanceof SrvCurUpdateToken) {
                srvRequestListener2.cursorUpdate(this, (SrvCurUpdateToken)object);
                continue;
            }
            if (object instanceof SrvCurDeleteToken) {
                srvRequestListener2.cursorDelete(this, (SrvCurDeleteToken)object);
                continue;
            }
            if (object instanceof SrvKeyToken) continue;
            if (object instanceof SrvDynamic2Token) {
                srvRequestListener2.dynamicRequest(this, (SrvDynamic2Token)object);
                continue;
            }
            if (object instanceof EOFException) {
                srvRequestListener2.disconnect(this, null);
                continue;
            }
            if (object instanceof SrvLogoutToken) {
                srvRequestListener2.disconnect(this, (SrvLogoutToken)object);
                continue;
            }
            if (object instanceof SrvBulkException) {
                srvRequestListener2.bulk(this, this._tdsin);
                continue;
            }
            if (object instanceof IOException) {
                srvRequestListener2.error(this, (IOException)object);
                continue;
            }
            if (object instanceof Exception) {
                srvRequestListener2.error(this, (Exception)object);
                continue;
            }
            Debug.asrt(false, "Invalid request token " + object.getClass().getName() + ", hence can't fire event");
            srvRequestListener2.error(this, new SrvProtocolException("Invalid request token " + object.getClass().getName() + ", hence can't fire event"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotify(String string, Object[] objectArray) throws IOException, SrvTypeException {
        SrvDataOutputStream srvDataOutputStream;
        SrvDataOutputStream srvDataOutputStream2 = srvDataOutputStream = this.getAsyncOut();
        synchronized (srvDataOutputStream2) {
            this.send(srvDataOutputStream, new SrvEventToken(string));
            if (objectArray != null && objectArray.length > 0) {
                this.sendParams(srvDataOutputStream, null, objectArray, 0);
            }
            this.sendDone(srvDataOutputStream, 0, false, true, false, true);
        }
    }

    protected synchronized SrvDataOutputStream getAsyncOut() throws IOException {
        if (this._asyncNotif == null) {
            try {
                this._asyncNotif = new SrvDataOutputStream(this._rawOut);
                this._asyncNotif.setBigEndian(this._tdsout.getBigEndian());
                this._asyncNotif.setPacketSize(this._tdsout.getPacketSize());
                this._asyncNotif.setEncoding(this._tdsout.getCharset());
                this._asyncNotif.setNotify();
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        return this._asyncNotif;
    }

    public void sendParams(Object[] objectArray, Object[] objectArray2, int n) throws IOException {
        this.sendParams(this._tdsout, objectArray, objectArray2, n);
    }

    private void sendParams(SrvDataOutputStream srvDataOutputStream, Object[] objectArray, Object[] objectArray2, int n) throws IOException {
        if (objectArray != null && objectArray.length != objectArray2.length) {
            throw new SrvTypeException("Number of names do not match number of data elements in results send");
        }
        ParamFormatToken paramFormatToken = null;
        Object[] objectArray3 = null;
        objectArray3 = objectArray != null ? objectArray : objectArray2;
        if (objectArray3.length * 136 > 65535 && this.isWidetableEnabled()) {
            paramFormatToken = new SrvParamFormat2Token();
        }
        if (paramFormatToken == null) {
            paramFormatToken = new SrvParamFormatToken();
        }
        SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter((SrvFormatToken)((Object)paramFormatToken), this.getClientCapability());
        for (int i = 0; i < objectArray3.length; ++i) {
            int n2 = 0;
            if (objectArray3[i] instanceof String) {
                n2 = ((String)objectArray3[i]).length();
            }
            srvJavaTypeFormatter.addFormat(objectArray3[i], null, n, n2);
        }
        this.send(srvDataOutputStream, paramFormatToken);
        SrvParamsToken srvParamsToken = new SrvParamsToken();
        srvJavaTypeFormatter.convertData(srvParamsToken, objectArray3);
        this.send(srvDataOutputStream, srvParamsToken);
    }

    public void sendDone(int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.sendDone(this._tdsout, n, bl, bl2, bl3, false);
    }

    private void sendDone(SrvDataOutputStream srvDataOutputStream, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        int n2 = 0;
        if (bl) {
            n2 |= 2;
        }
        if (bl4) {
            n2 |= 0x40;
        }
        n2 = bl2 ? (n2 |= 0) : (n2 |= 1);
        if (n >= 0) {
            n2 |= 0x10;
        } else {
            n = 0;
        }
        if (bl3) {
            if (bl2) {
                this.send(srvDataOutputStream, new SrvDoneToken(n2, 0, n));
            } else {
                this.send(srvDataOutputStream, new SrvDoneInProcToken(n2, 0, n));
            }
        } else {
            this.send(srvDataOutputStream, new SrvDoneToken(n2, 0, n));
        }
    }

    protected String getCharset() {
        return Iana.reverseLookupIana(this._encoding);
    }

    public boolean isWidetableEnabled() {
        return this.getClientCapability()._reqCaps.get(59) & !this.getClientCapability()._respCaps.get(45);
    }

    public Object getSessionData(Object object) {
        return this._sessionData.get(object);
    }

    public void setSessionData(Object object, Object object2) {
        this._sessionData.put(object, object2);
    }

    protected Socket getSocket() {
        return this._srvSocket;
    }

    protected TdsOutputStream getOutputStream() {
        return this._tdsout;
    }
}

