/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.security.asn1.DERObject;
import com.sybase.jdbc4.security.asn1.DEROutputStream;
import com.sybase.jdbc4.security.asn1.x509.RSAPublicKeyStructure;
import com.sybase.jdbc4.tds.MsgToken;
import com.sybase.jdbc4.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc4.tds.SrvLoginToken;
import com.sybase.jdbc4.tds.SrvMsgToken;
import com.sybase.jdbc4.tds.SrvParamFormatToken;
import com.sybase.jdbc4.tds.SrvParamsToken;
import com.sybase.jdbc4.tds.SrvProtocolException;
import com.sybase.jdbc4.tds.SrvReceiver;
import com.sybase.jdbc4.tds.SrvSession;
import com.sybase.jdbc4.utils.JCEProviderUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Vector;
import javax.crypto.Cipher;
import sun.misc.BASE64Encoder;

public class SrvSecLoginContext {
    private static int LOG_MSG_PARM_ID = 0;
    private static int REM_MSG_PARM_ID = 1;
    private static int CIPHER_SUITE = 1;
    private String[] ENCRYPT_MSGS = new String[]{"Client determines encryption.", "Encrypt2 is required.", "Encrypt3 or Encrypt2 is required.", "Encrypt3 is required."};
    private SrvReceiver _srvReceiver;
    private byte[] _nonce = new byte[32];
    private Cipher _cipherSuite = null;
    RSAPrivateKey _privateKey = null;
    RSAPublicKey _publicKey = null;

    public SrvSecLoginContext(SrvReceiver srvReceiver) {
        this(srvReceiver, null);
    }

    public SrvSecLoginContext(SrvReceiver srvReceiver, Cipher cipher) {
        this._srvReceiver = srvReceiver;
        try {
            this._cipherSuite = JCEProviderUtil.createCipherSuite();
        }
        catch (GeneralSecurityException generalSecurityException) {
            String string = "Failed to instantiate Cipher object. Transformation RSA/ECB/OAEPWithSHA1AndMGF1Padding or RSA/NONE/OAEPWithSHA1AndMGF1Padding implemented by any of the loaded JCE providers.";
            throw new RuntimeException(string);
        }
    }

    String doLogin(SrvSession srvSession, SrvLoginToken srvLoginToken) {
        int n = srvSession.getLogin()._lseclogin;
        switch (this._srvReceiver.getEncryptMode()) {
            case 3: {
                this.validateEncryptLevel(srvSession, n, 128);
                break;
            }
            case 2: {
                this.validateEncryptLevel(srvSession, n, 160);
                break;
            }
            case 1: {
                this.validateEncryptLevel(srvSession, n, 32);
                n &= 0x20;
            }
        }
        String string = srvLoginToken.getPassword();
        if ((n & 0x80) != 0) {
            string = this.doEncrypt3(srvSession, srvLoginToken);
        } else if ((n & 0x20) != 0) {
            string = this.doEncrypt2(srvSession, srvLoginToken);
        }
        return string;
    }

    private void validateEncryptLevel(SrvSession srvSession, int n, int n2) {
        if ((n & n2) == 0) {
            String string = "Received insufficient encryption level from client. " + this.ENCRYPT_MSGS[this._srvReceiver.getEncryptMode()];
            try {
                this._srvReceiver.sendLogin(srvSession, srvSession.getClientCapability(), this._srvReceiver._server, false, srvSession.getLogin().getPacketSize());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException(string);
        }
    }

    private String doEncrypt3(SrvSession srvSession, SrvLoginToken srvLoginToken) {
        String string = srvLoginToken.getPassword();
        try {
            Object object;
            byte[] byArray;
            this._nonce = this._srvReceiver.nextNonce();
            KeyPair keyPair = this._srvReceiver.getEncrypt3Keys();
            this._privateKey = (RSAPrivateKey)keyPair.getPrivate();
            this._publicKey = (RSAPublicKey)keyPair.getPublic();
            this._srvReceiver.sendLogNegotiateAck(srvSession);
            this.sendKey(srvSession, (short)30);
            byte[] byArray2 = this.getEncryptedMsg(srvSession, 31, LOG_MSG_PARM_ID);
            if (byArray2 != null) {
                byArray = this.decryptMessage(byArray2);
                object = new byte[this._nonce.length];
                System.arraycopy(byArray, 0, object, 0, ((byte[])object).length);
                if (!Arrays.equals(object, this._nonce)) {
                    this._srvReceiver.sendLogin(srvSession, srvSession.getClientCapability(), this._srvReceiver._server, false, srvLoginToken.getPacketSize());
                    throw new SrvProtocolException("Invalid nonce received from client");
                }
                string = new String(byArray, this._nonce.length, byArray.length - ((byte[])object).length);
            }
            if ((byArray2 = this.getEncryptedMsg(srvSession, 32, REM_MSG_PARM_ID)) != null) {
                byArray = this.decryptMessage(byArray2);
                object = new String(byArray);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return string;
    }

    private String doEncrypt2(SrvSession srvSession, SrvLoginToken srvLoginToken) {
        String string = srvLoginToken.getPassword();
        try {
            byte[] byArray;
            this._nonce = new byte[0];
            KeyPair keyPair = this._srvReceiver.getEncrypt2Keys();
            this._privateKey = (RSAPrivateKey)keyPair.getPrivate();
            this._publicKey = (RSAPublicKey)keyPair.getPublic();
            this._srvReceiver.sendLogNegotiateAck(srvSession);
            this.sendKey(srvSession, (short)14);
            byte[] byArray2 = this.getEncryptedMsg(srvSession, 15, LOG_MSG_PARM_ID);
            if (byArray2 != null) {
                byArray = this.decryptMessage(byArray2);
                string = new String(byArray);
            }
            if ((byArray2 = this.getEncryptedMsg(srvSession, 22, REM_MSG_PARM_ID)) != null) {
                byArray = this.decryptMessage(byArray2);
                String string2 = new String(byArray);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return string;
    }

    private void sendKey(SrvSession srvSession, short s) {
        try {
            MsgToken msgToken = new MsgToken(1, s);
            msgToken.send(srvSession.getOutputStream());
            String string = this.createPEMKey(this._publicKey);
            Vector<Object> vector = new Vector<Object>();
            vector.add(CIPHER_SUITE);
            vector.add(string.getBytes());
            if (this._nonce != null && this._nonce.length > 0) {
                vector.add(this._nonce);
            }
            srvSession.sendParams(null, vector.toArray(), 1);
            srvSession.sendDone(-1, false, true, false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private byte[] getEncryptedMsg(SrvSession srvSession, int n, int n2) throws SrvProtocolException {
        SrvMsgToken srvMsgToken = this.getMessage(srvSession);
        if (srvMsgToken != null && srvMsgToken.getMessageID() != n) {
            throw new SrvProtocolException("Expected message type: " + n + ", received: " + srvMsgToken.getMessageID());
        }
        Object[] objectArray = null;
        byte[] byArray = null;
        if (srvMsgToken.hasParameters() && (objectArray = this.getParameters(srvSession)) != null) {
            byArray = (byte[])objectArray[n2];
        }
        return byArray;
    }

    private Object[] getParameters(SrvSession srvSession) {
        Object[] objectArray = null;
        try {
            SrvParamFormatToken srvParamFormatToken = (SrvParamFormatToken)srvSession.receive();
            SrvParamsToken srvParamsToken = (SrvParamsToken)srvSession.receive();
            if (srvParamFormatToken != null && srvParamsToken != null) {
                SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter(srvParamFormatToken, srvSession.getClientCapability());
                objectArray = srvJavaTypeFormatter.convertData(srvParamsToken);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return objectArray;
    }

    private byte[] decryptMessage(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            this._cipherSuite.init(2, this._privateKey);
            byArray2 = this._cipherSuite.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return byArray2;
    }

    private SrvMsgToken getMessage(SrvSession srvSession) {
        SrvMsgToken srvMsgToken = null;
        try {
            srvMsgToken = (SrvMsgToken)srvSession.receive();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return srvMsgToken;
    }

    private String createPEMKey(RSAPublicKey rSAPublicKey) throws IOException {
        RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        DERObject dERObject = rSAPublicKeyStructure.toASN1Object();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dERObject);
        return this.encodePEMKey(byteArrayOutputStream);
    }

    private String encodePEMKey(ByteArrayOutputStream byteArrayOutputStream) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----BEGIN RSA PUBLIC KEY-----").append("\n").append(bASE64Encoder.encode(byteArrayOutputStream.toByteArray())).append("\n").append("-----END RSA PUBLIC KEY-----").append("\n");
        return stringBuffer.toString();
    }
}

