/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.SrvDataFormat;
import com.sybase.jdbc4.tds.SrvDataToken;
import com.sybase.jdbc4.tds.SrvFormatToken;
import com.sybase.jdbc4.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc4.tds.SrvTypeFormatter;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.tds.Token;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;

public class SrvRPCToken
extends Token
implements SrvDataToken,
SrvFormatToken,
Dumpable {
    private int _totalLength;
    private String _rpcName;
    private int _options;
    private TdsInputStream _in;
    private SrvDataFormat _currentFormat;

    public SrvRPCToken(TdsInputStream tdsInputStream) throws IOException {
        this._totalLength = tdsInputStream.readShort();
        int n = tdsInputStream.readUnsignedByte();
        this._rpcName = tdsInputStream.readString(n);
        this._options = tdsInputStream.readUnsignedShort();
        this._in = tdsInputStream;
    }

    @Override
    public TdsInputStream getStream() {
        return this._in;
    }

    @Override
    public void setFormatter(SrvTypeFormatter srvTypeFormatter) {
    }

    @Override
    public void addFormat(DataFormat dataFormat) {
    }

    public int getLength() {
        return 0;
    }

    @Override
    public int getFormatCount() {
        return 1;
    }

    @Override
    public DataFormat formatAt(int n) {
        return this._currentFormat;
    }

    @Override
    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(224)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "RPC Token (0x" + HexConverts.hexConvert(224, 1) + ");");
            } else {
                dumpInfo.addInfo("Token", 1, "RPC Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLength);
            }
            if (dumpFilter.includesDetail(3)) {
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Name Length", 1, this._rpcName.length());
                }
                dumpInfo.addText("Name", this._rpcName.length(), this._rpcName);
                String[] stringArray = new String[]{"RPC_UNUSED", "RPC_RECOMPILE"};
                dumpInfo.addBitfield("Options", 2, this._options, stringArray);
            }
        }
        int n = this._totalLength;
        while (n > 0) {
            this._currentFormat = new RPCFormat(this._in);
            n -= this._currentFormat.length();
            SrvJavaTypeFormatter srvJavaTypeFormatter = new SrvJavaTypeFormatter(this, null, false);
            Object[] objectArray = srvJavaTypeFormatter.convertData(this);
            int[] nArray = srvJavaTypeFormatter.getDataLengths();
            n -= nArray[0];
            if (!dumpFilter.includesToken(224) || !dumpFilter.includesDetail(3) && !dumpFilter.includesDetail(6) || dumpInfo == null) continue;
            dumpInfo.addInfo(this._currentFormat.dump(dumpFilter));
            int[] nArray2 = srvJavaTypeFormatter.getLengthSizes();
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", nArray2[0], nArray[0]);
            }
            dumpInfo.addValue("Row data", nArray[0], objectArray[0]);
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 224;
    }

    private class RPCFormat
    extends SrvDataFormat
    implements Dumpable {
        private int _maxLength;
        private int _actualLength;

        protected RPCFormat(TdsInputStream tdsInputStream) throws IOException {
            try {
                int n = tdsInputStream.readUnsignedByte();
                this._name = tdsInputStream.readString(n);
                this._status = tdsInputStream.readUnsignedByte();
                this._datatype = tdsInputStream.readUnsignedByte();
                int n2 = RPCFormat.lengthSize(this._datatype);
                if (this._datatype == 106 || this._datatype == 108) {
                    this._maxLength = tdsInputStream.readUnsignedByte();
                    this._precision = tdsInputStream.readUnsignedByte();
                    this._scale = tdsInputStream.readUnsignedByte();
                    this._actualLength = tdsInputStream.readUnsignedByte();
                } else if (n2 == 1) {
                    this._maxLength = tdsInputStream.readUnsignedByte();
                    this._actualLength = tdsInputStream.readUnsignedByte();
                } else if (n2 == 4) {
                    this._maxLength = tdsInputStream.readInt();
                    this._actualLength = tdsInputStream.readInt();
                }
            }
            catch (IOException iOException) {
                RPCFormat.readSQE(iOException);
            }
        }

        @Override
        public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
            DumpInfo dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(7)) {
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Name Length", 1, this._name.length());
                }
                dumpInfo.addText("Name", this._name.length(), this._name);
                String[] stringArray = new String[]{"RPC_STATUS_UNUSED", "RPC_OUTPUT", "RPC_NODEF"};
                dumpInfo.addBitfield("Status", 1, this._status, stringArray);
                dumpInfo.addInfo("Data Type", 1, RPCFormat.getDataTypeString(this._datatype));
                if (dumpFilter.includesDetail(1) && RPCFormat.lengthSize(this._datatype) > 0) {
                    dumpInfo.addInt("Maximum Length", RPCFormat.lengthSize(this._datatype), this._maxLength);
                }
                if (this._datatype == 106 || this._datatype == 108) {
                    dumpInfo.addHex("Precision", 1, this._precision);
                    dumpInfo.addHex("Scale", 1, this._scale);
                }
                if (dumpFilter.includesDetail(1) && RPCFormat.lengthSize(this._datatype) > 0) {
                    dumpInfo.addInt("Actual Length", RPCFormat.lengthSize(this._datatype), this._actualLength);
                }
            }
            return dumpInfo;
        }

        public int getType() {
            return -1;
        }
    }
}

