/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.EventToken;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;

public class SrvEventToken
extends EventToken
implements Dumpable {
    protected int _totalLen;
    protected int _nameLen;

    public SrvEventToken(TdsInputStream tdsInputStream) throws IOException {
        try {
            this._totalLen = tdsInputStream.readUnsignedShort();
            this._nameLen = tdsInputStream.readUnsignedByte();
            this._name = tdsInputStream.readString(this._nameLen);
        }
        catch (IOException iOException) {
            SrvEventToken.readSQE(iOException);
        }
    }

    public SrvEventToken(String string) {
        super(string);
        this._nameLen = string.length();
        this._totalLen = this._nameLen + 1;
    }

    @Override
    protected void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(162);
        byte[] byArray = tdsOutputStream.stringToByte(this._name);
        tdsOutputStream.writeShort(byArray.length + 1);
        tdsOutputStream.writeByte(byArray.length);
        tdsOutputStream.write(byArray);
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(162)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "EVENT_NOTICE Token (0x" + HexConverts.hexConvert(162, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "EVENT_NOTICE Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLen);
            }
            if (dumpFilter.includesDetail(3)) {
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Name Length", 2, this._nameLen);
                }
                dumpInfo.addText("Name", this._nameLen, this._name);
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 162;
    }
}

