/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.EnvChangeToken;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SrvEnvChangeToken
extends EnvChangeToken
implements Dumpable {
    private int _totalLength;
    private Vector _variables;

    public SrvEnvChangeToken() {
        this._totalLength = 0;
        this._variables = new Vector();
    }

    public SrvEnvChangeToken(TdsInputStream tdsInputStream) throws IOException {
        this._variables = new Vector();
        int n = this._totalLength = (int)tdsInputStream.readShort();
        while (n > 0) {
            VariableInfo variableInfo = new VariableInfo(tdsInputStream);
            this._variables.addElement(variableInfo);
            n -= variableInfo.getLength();
            switch (variableInfo.getType()) {
                case 3: 
                case 4: {
                    this._newValue = variableInfo.getNewVal();
                }
            }
        }
        if (n < 0) {
            throw new IOException("Malformed EnvChange token lengths");
        }
    }

    @Override
    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(227);
        tdsOutputStream.writeShort(this._totalLength);
        Enumeration enumeration = this._variables.elements();
        while (enumeration.hasMoreElements()) {
            VariableInfo variableInfo = (VariableInfo)enumeration.nextElement();
            variableInfo.send(tdsOutputStream);
        }
    }

    public void addVariable(int n, String string, String string2) {
        VariableInfo variableInfo = new VariableInfo(n, string, string2);
        this._variables.addElement(variableInfo);
        this._totalLength += variableInfo.getLength();
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(227)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ENVCHANGE Token (0x" + HexConverts.hexConvert(227, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "ENVCHANGE Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLength);
            }
            if (dumpFilter.includesDetail(3)) {
                Enumeration enumeration = this._variables.elements();
                while (enumeration.hasMoreElements()) {
                    VariableInfo variableInfo = (VariableInfo)enumeration.nextElement();
                    dumpInfo.addInfo(variableInfo.dump(dumpFilter));
                }
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 227;
    }

    public String getCharset() {
        return this._envType == 3 ? this._newValue : null;
    }

    public String getPacketSize() {
        return this._envType == 4 ? this._newValue : null;
    }

    private class VariableInfo
    implements Dumpable {
        private int _type;
        private int _newValLen;
        private String _newVal;
        private int _oldValLen;
        private String _oldVal;

        protected VariableInfo(int n, String string, String string2) {
            this._type = n;
            this._oldVal = string;
            this._newVal = string2;
            this._oldValLen = this._oldVal.length();
            this._newValLen = this._newVal.length();
        }

        public void send(TdsOutputStream tdsOutputStream) throws IOException {
            tdsOutputStream.writeByte(this._type);
            byte[] byArray = tdsOutputStream.stringToByte(this._newVal);
            tdsOutputStream.writeByte(this._newValLen);
            tdsOutputStream.write(byArray);
            byArray = tdsOutputStream.stringToByte(this._oldVal);
            tdsOutputStream.writeByte(this._oldValLen);
            tdsOutputStream.write(byArray);
        }

        protected VariableInfo(TdsInputStream tdsInputStream) throws IOException {
            this._type = tdsInputStream.readUnsignedByte();
            this._newValLen = tdsInputStream.readUnsignedByte();
            if (this._newValLen != 0) {
                this._newVal = tdsInputStream.readString(this._newValLen);
            }
            this._oldValLen = tdsInputStream.readUnsignedByte();
            if (this._oldValLen != 0) {
                this._oldVal = tdsInputStream.readString(this._oldValLen);
            }
        }

        protected int getLength() {
            return 2 + this._newValLen + 1 + this._oldValLen;
        }

        @Override
        public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
            DumpInfo dumpInfo = dumpFilter.getDumpInfo();
            String[] stringArray = new String[]{"<unrecognized>", "ENV_DB", "ENV_LANG", "ENV_CHARSET", "ENV_PACKETSIZE"};
            dumpInfo.addField("Type", 1, this._type, stringArray);
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length of New Value", 1, this._newValLen);
            }
            if (this._newValLen > 0) {
                dumpInfo.addText("New Value", this._newValLen, this._newVal);
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length of Old Value", 1, this._oldValLen);
            }
            if (this._oldValLen > 0) {
                dumpInfo.addText("Old Value", this._oldValLen, this._oldVal);
            }
            return dumpInfo;
        }

        @Override
        public int getTokenType() {
            return -1;
        }

        protected int getType() {
            return this._type;
        }

        protected String getNewVal() {
            return this._newVal;
        }
    }
}

