/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.SrvCurInfoToken;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.utils.DumpInfo;
import java.io.IOException;

public class SrvCurInfo3Token
extends SrvCurInfoToken
implements Dumpable {
    static final int UNKNOWN = -1;
    static final int BEFORE_FIRST = 0;
    static final int AFTER_LAST = -2;
    int _totalNumRows;
    int _rowNum;

    public SrvCurInfo3Token(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
    }

    public SrvCurInfo3Token() {
    }

    @Override
    protected int readStatus(TdsInputStream tdsInputStream) throws IOException {
        return tdsInputStream.readInt();
    }

    @Override
    protected void readMetaInfo(TdsInputStream tdsInputStream, int n) throws IOException {
        this._rowNum = tdsInputStream.readInt();
        n -= 4;
        this._totalNumRows = tdsInputStream.readInt();
        n -= 4;
        if ((this._status & 0x20) != 0) {
            this._fetchSize = tdsInputStream.readInt();
            n -= 4;
        }
    }

    @Override
    protected int getStatusLength() {
        return 4;
    }

    @Override
    protected int getMetaLength() {
        int n = 0;
        n += 8;
        if ((this._cursor.getCurInfoStatus() & 0x20) != 0) {
            n += 4;
        }
        return n;
    }

    @Override
    protected void sendStatus(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeInt(this._cursor.getCurInfoStatus());
    }

    @Override
    protected void sendMetaInfo(TdsOutputStream tdsOutputStream) throws IOException {
        int n = this._cursor.getLastCommand() == 1 ? -1 : this._cursor.getRow();
        tdsOutputStream.writeInt(n);
        int n2 = this._cursor.getTotalNumRows();
        tdsOutputStream.writeInt(n2);
        if ((this._cursor.getCurInfoStatus() & 0x20) != 0) {
            tdsOutputStream.writeInt(this._cursor.getFetchSize());
        }
    }

    @Override
    protected String getTokenName() {
        return "CURINFO3";
    }

    @Override
    protected void addCommandField(DumpInfo dumpInfo) {
        String[] stringArray = new String[]{"<unrecognized>", "CUR_SETCURROWS", "CUR_INQUIRE", "CUR_INFORM", "CUR_LISTALL", "CUR_GETTOTALROWS", "CUR_GETROWNUM"};
        dumpInfo.addField("Command", 1, this._command, stringArray);
    }

    @Override
    protected void addStatusField(DumpInfo dumpInfo) {
        String[] stringArray = new String[]{"UNUSED", "CUR_IS_DECLARED", "CUR_IS_OPEN", "CUR_IS_CLOSED", "CUR_IS_RDONLY", "CUR_IS_UPDATABLE", "CUR_IS_ROWCNT", "CUR_IS_DALLOC", "CUR_IS_SCROLLABLE", "CUR_IS_IMPLICIT", "CUR_IS_SENSITIVE", "CUR_IS_INSENSITIVE", "CUR_IS_SEMISENSITIVE", "CUR_IS_KEYSETDRIVEN"};
        dumpInfo.addBitfield("Status", 4, this._status, stringArray);
    }

    @Override
    protected void addMetaFields(DumpInfo dumpInfo) {
        String string = "";
        String string2 = "";
        switch (this._rowNum) {
            case 0: {
                string = " (BEFORE_FIRST)";
                break;
            }
            case -1: {
                string = " (UNKNOWN)";
                break;
            }
            case -2: {
                string = " (AFTER_LAST)";
            }
        }
        switch (this._totalNumRows) {
            case -1: {
                string2 = " (UNKNOWN)";
            }
        }
        dumpInfo.addInfo("Row Number", 4, this._rowNum + string);
        dumpInfo.addInfo("Total Number of Rows", 4, this._totalNumRows + string2);
        if ((this._status & 0x20) != 0) {
            dumpInfo.addInt("Fetch Size", 4, this._fetchSize);
        }
    }

    @Override
    public int getTokenType() {
        return 136;
    }
}

