/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.CurDeclareToken;
import com.sybase.jdbc4.tds.Dumpable;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.utils.DumpFilter;
import com.sybase.jdbc4.utils.DumpInfo;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;

public class SrvCurDeclareToken
extends CurDeclareToken
implements Dumpable {
    protected long _curlen = 0L;
    protected int _options = 0;
    protected int _status = 0;
    protected int _nameLen = 0;
    protected String _cursorName = null;
    protected long _queryLen = 0L;
    protected String _query = null;
    protected int _numColumns = 0;
    protected String[] _colNames;
    public static final int CUR_TOKEN_NAME = 0;
    public static final int CUR_TOKEN = 1;
    public static final int CUR_LEN_FIELD_SIZE = 2;
    public static final int CUR_LEN = 3;
    public static final int CUR_ID = 4;
    public static final int CUR_NAMELEN = 5;
    public static final int CUR_NAME = 6;
    public static final int CUR_OPTIONS = 7;
    public static final int CUR_STATUS = 8;

    public SrvCurDeclareToken(TdsInputStream tdsInputStream) throws IOException {
        this._curlen = this.readTokenLength(tdsInputStream);
        this._nameLen = tdsInputStream.readUnsignedByte();
        this._cursorName = tdsInputStream.readString(this._nameLen);
        this._options = this.readOptions(tdsInputStream);
        this._status = tdsInputStream.readUnsignedByte();
        this._queryLen = this.readQueryLength(tdsInputStream);
        this._query = tdsInputStream.readString((int)this._queryLen);
        this._numColumns = this.readNumColumns(tdsInputStream);
        if (this._numColumns > 0) {
            this._colNames = new String[this._numColumns];
            for (int i = 0; i < this._numColumns; ++i) {
                int n = tdsInputStream.readUnsignedByte();
                this._colNames[i] = tdsInputStream.readString(n);
            }
        }
    }

    protected long readTokenLength(TdsInputStream tdsInputStream) throws IOException {
        int n = tdsInputStream.readUnsignedShort();
        return n;
    }

    protected long readQueryLength(TdsInputStream tdsInputStream) throws IOException {
        int n = tdsInputStream.readUnsignedShort();
        return n;
    }

    protected int readNumColumns(TdsInputStream tdsInputStream) throws IOException {
        int n = tdsInputStream.readUnsignedByte();
        return n;
    }

    protected int readOptions(TdsInputStream tdsInputStream) throws IOException {
        int n = tdsInputStream.readUnsignedByte();
        return n;
    }

    public String[] cols() {
        return this._colNames;
    }

    public String name() {
        return this._cursorName;
    }

    public static DumpInfo preDump(DumpFilter dumpFilter, Object[] objectArray) {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(SrvCurDeclareToken.mInt(objectArray[1]))) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, objectArray[0] + " Token (0x" + HexConverts.hexConvert(SrvCurDeclareToken.mInt(objectArray[1]), 1) + "); variable length");
            } else {
                dumpInfo.addInfo("Token", 1, objectArray[0] + " Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", SrvCurDeclareToken.mInt(objectArray[2]), SrvCurDeclareToken.mInt(objectArray[3]));
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(9)) {
                if (SrvCurDeclareToken.mInt(objectArray[4]) == 0) {
                    if (dumpFilter.includesDetail(1)) {
                        dumpInfo.addInt("Cursor Name Length", 1, SrvCurDeclareToken.mInt(objectArray[5]));
                    }
                    dumpInfo.addText("Cursor Name", SrvCurDeclareToken.mInt(objectArray[5]), (String)objectArray[6]);
                } else {
                    dumpInfo.addHex("Cursor Id", 4, SrvCurDeclareToken.mInt(objectArray[4]));
                }
                if (objectArray[8] != null) {
                    String[] stringArray = new String[]{"UNUSED", "CUR_HASARGS"};
                    dumpInfo.addBitfield("Status", 1, SrvCurDeclareToken.mInt(objectArray[8]), stringArray);
                }
            }
        }
        return dumpInfo;
    }

    protected static int mInt(Object object) {
        return (Integer)object;
    }

    @Override
    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        Object[] objectArray = new Object[]{"CURDECLARE", new Integer(134), new Integer(2), new Integer((int)this._curlen), new Integer(0), new Integer(this._nameLen), this._cursorName, null, new Integer(this._status)};
        DumpInfo dumpInfo = SrvCurDeclareToken.preDump(dumpFilter, objectArray);
        if (dumpFilter.includesToken(134) && (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(9))) {
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Statement Length", 2, this._queryLen);
            }
            String[] stringArray = new String[]{"UNUSED", "CUR_RDONLY", "CUR_UPDATABLE", "<unrecognized>", "CUR_DYNAMIC"};
            dumpInfo.addBitfield("Options", 1, this._options, stringArray);
            dumpInfo.addText("Statement", (int)this._queryLen, this._query);
            dumpInfo.addInt("No. of Columns", 1, this._numColumns);
            for (int i = 0; i < this._numColumns; ++i) {
                dumpInfo.addInt("Column ", 0, i + 1);
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Column Name Length", 1, this._colNames[i].length());
                }
                dumpInfo.addText("Column Name ", this._colNames[i].length(), this._colNames[i]);
            }
        }
        return dumpInfo;
    }

    @Override
    public int getTokenType() {
        return 134;
    }

    public String getCursorName() {
        return this._cursorName;
    }

    public int getCursorOptions() {
        return this._options;
    }

    public String getCursorStatement() {
        return this._query;
    }
}

