/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybCursorResultSet;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.utils.LogUtil;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybScrollCursorResultSet
extends SybCursorResultSet
implements com.sybase.jdbcx.SybCursorResultSet {
    private static Logger LOG = Logger.getLogger(SybScrollCursorResultSet.class.getName());
    private static volatile long _logIdCounter = 0L;
    private int _totalNumRows = -4;

    protected SybScrollCursorResultSet(String string, SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        super(string, sybStatement, protocolResultSet);
        this._logId = string + "_Sr" + _logIdCounter++;
        int n = this._cursor.getTotalRowCount();
        if (n != -1) {
            this._totalNumRows = n;
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " absolute(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " absolute(int)");
            }
        }
        this.clearWarnings();
        boolean bl = false;
        if (n == 0) {
            this.beforeFirst();
            return false;
        }
        if (this._prs.isResultSetEmpty()) {
            return bl;
        }
        bl = this._prs.absolute(n);
        return bl;
    }

    @Override
    public boolean previous() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " previous()");
        }
        this.clearWarnings();
        boolean bl = this._prs.previous();
        return bl;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " relative(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " relative(int)");
            }
        }
        this.clearWarnings();
        boolean bl = false;
        if (this._prs.isBeforeFirst() || this._prs.isAfterLast()) {
            return false;
        }
        bl = this._prs.relative(n);
        return bl;
    }

    @Override
    public boolean first() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " first()");
        }
        this.clearWarnings();
        boolean bl = this._prs.first();
        return bl;
    }

    @Override
    public boolean last() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " last()");
        }
        this.clearWarnings();
        boolean bl = this._prs.last();
        return bl;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isBeforeFirst()");
        }
        boolean bl = false;
        if (!this._prs.isResultSetEmpty()) {
            bl = this._prs.isBeforeFirst();
        }
        return bl;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isFirst()");
        }
        boolean bl = this._prs.isFirst();
        return bl;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isLast()");
        }
        boolean bl = this._prs.isLast();
        return bl;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isAfterLast()");
        }
        boolean bl = false;
        if (!this._prs.isResultSetEmpty()) {
            bl = this._prs.isAfterLast();
        }
        return bl;
    }

    @Override
    public int getRow() throws SQLException {
        int n;
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getRow()");
        }
        if ((n = this._prs.getRowNumber()) == -1) {
            return 0;
        }
        return n;
    }

    @Override
    protected void checkIfReadableRow() throws SQLException {
        if (this._prs.isBeforeFirst()) {
            ErrorMessage.raiseError("JZ0R1");
        } else if (this._prs.isAfterLast()) {
            ErrorMessage.raiseError("JZ0R5");
        }
    }

    @Override
    protected boolean checkRowIndexBeforeProtocolNext() {
        return false;
    }

    @Override
    protected void adjustRowIndexesAfterProtocolNext() {
    }
}

