/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

public class HexNumberFormat
extends Format {
    public static final String RCS_ID = "$Id: HexNumberFormat.java,v 1.1 2000/05/20 17:10:15 time Exp $";
    public static final String RCS_REV = "$Revision: 1.1 $";
    private static char[] lowChars = new char[20];
    private static char[] uprChars = new char[20];
    private int count;
    private String pattern;
    private static char[] hexChars;

    public static final HexNumberFormat getInstance() {
        return new HexNumberFormat("XXXXXXXX");
    }

    public HexNumberFormat(String pattern) {
        this.pattern = pattern;
        this.count = pattern.length();
        hexChars = pattern.charAt(0) == 'X' ? uprChars : lowChars;
    }

    public String format(int hexNum) throws IllegalArgumentException {
        FieldPosition pos = new FieldPosition(0);
        StringBuffer hexBuf = new StringBuffer(8);
        this.format(new Integer(hexNum), hexBuf, pos);
        return hexBuf.toString();
    }

    public StringBuffer format(Object hexInt, StringBuffer appendTo, FieldPosition fieldPos) throws IllegalArgumentException {
        char[] hexBuf = new char[16];
        int end = fieldPos.getEndIndex();
        int beg = fieldPos.getBeginIndex();
        int hexNum = (Integer)hexInt;
        int i = 7;
        while (i >= 0) {
            hexBuf[i] = hexChars[hexNum & 0xF];
            hexNum >>= 4;
            --i;
        }
        int i2 = 8 - this.count;
        while (i2 < 8) {
            appendTo.append(hexBuf[i2]);
            ++i2;
        }
        return appendTo;
    }

    public int parse(String source) throws ParseException {
        throw new ParseException("unimplemented!", 0);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    static {
        HexNumberFormat.lowChars[0] = 48;
        HexNumberFormat.uprChars[0] = 48;
        HexNumberFormat.lowChars[1] = 49;
        HexNumberFormat.uprChars[1] = 49;
        HexNumberFormat.lowChars[2] = 50;
        HexNumberFormat.uprChars[2] = 50;
        HexNumberFormat.lowChars[3] = 51;
        HexNumberFormat.uprChars[3] = 51;
        HexNumberFormat.lowChars[4] = 52;
        HexNumberFormat.uprChars[4] = 52;
        HexNumberFormat.lowChars[5] = 53;
        HexNumberFormat.uprChars[5] = 53;
        HexNumberFormat.lowChars[6] = 54;
        HexNumberFormat.uprChars[6] = 54;
        HexNumberFormat.lowChars[7] = 55;
        HexNumberFormat.uprChars[7] = 55;
        HexNumberFormat.lowChars[8] = 56;
        HexNumberFormat.uprChars[8] = 56;
        HexNumberFormat.lowChars[9] = 57;
        HexNumberFormat.uprChars[9] = 57;
        HexNumberFormat.uprChars[10] = 65;
        HexNumberFormat.lowChars[10] = 97;
        HexNumberFormat.uprChars[11] = 66;
        HexNumberFormat.lowChars[11] = 98;
        HexNumberFormat.uprChars[12] = 67;
        HexNumberFormat.lowChars[12] = 99;
        HexNumberFormat.uprChars[13] = 68;
        HexNumberFormat.lowChars[13] = 100;
        HexNumberFormat.uprChars[14] = 69;
        HexNumberFormat.lowChars[14] = 101;
        HexNumberFormat.uprChars[15] = 70;
        HexNumberFormat.lowChars[15] = 102;
    }
}

