/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.BuiltInName;
import jxl.biff.ByteData;
import jxl.biff.CellReferenceHelper;
import jxl.biff.CountryCode;
import jxl.biff.Fonts;
import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.RangeImpl;
import jxl.biff.RecordData;
import jxl.biff.WorkbookMethods;
import jxl.biff.WritableRecordData;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.drawing.Origin;
import jxl.biff.formula.ExternalSheet;
import jxl.format.Colour;
import jxl.format.RGB;
import jxl.read.biff.WorkbookParser;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.biff.BOFRecord;
import jxl.write.biff.BackupRecord;
import jxl.write.biff.BookboolRecord;
import jxl.write.biff.BoundsheetRecord;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.CodepageRecord;
import jxl.write.biff.CountryRecord;
import jxl.write.biff.DSFRecord;
import jxl.write.biff.DateRecord;
import jxl.write.biff.EOFRecord;
import jxl.write.biff.ExternalNameRecord;
import jxl.write.biff.ExternalSheetRecord;
import jxl.write.biff.File;
import jxl.write.biff.FunctionGroupCountRecord;
import jxl.write.biff.HideobjRecord;
import jxl.write.biff.InterfaceEndRecord;
import jxl.write.biff.InterfaceHeaderRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MMSRecord;
import jxl.write.biff.NameRecord;
import jxl.write.biff.NineteenFourRecord;
import jxl.write.biff.ObjProjRecord;
import jxl.write.biff.PasswordRecord;
import jxl.write.biff.PrecisionRecord;
import jxl.write.biff.Prot4RevPassRecord;
import jxl.write.biff.Prot4RevRecord;
import jxl.write.biff.ProtectRecord;
import jxl.write.biff.RefreshAllRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.Styles;
import jxl.write.biff.SupbookRecord;
import jxl.write.biff.TabIdRecord;
import jxl.write.biff.UsesElfsRecord;
import jxl.write.biff.Window1Record;
import jxl.write.biff.WindowProtectRecord;
import jxl.write.biff.WritableFonts;
import jxl.write.biff.WritableFormattingRecords;
import jxl.write.biff.WritableSheetImpl;
import jxl.write.biff.WriteAccessRecord;

public class WritableWorkbookImpl
extends WritableWorkbook
implements ExternalSheet,
WorkbookMethods {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$WritableWorkbookImpl == null ? (class$jxl$write$biff$WritableWorkbookImpl = WritableWorkbookImpl.class$("jxl.write.biff.WritableWorkbookImpl")) : class$jxl$write$biff$WritableWorkbookImpl);
    private FormattingRecords formatRecords;
    private File outputFile;
    private ArrayList sheets;
    private Fonts fonts;
    private ExternalSheetRecord externSheet;
    private ArrayList supbooks;
    private ArrayList names;
    private HashMap nameRecords;
    private SharedStrings sharedStrings;
    private boolean closeStream;
    private boolean wbProtected;
    private WorkbookSettings settings;
    private ArrayList rcirCells;
    private DrawingGroup drawingGroup;
    private Styles styles;
    private boolean containsMacros;
    private ButtonPropertySetRecord buttonPropertySet;
    private CountryRecord countryRecord;
    private static Object SYNCHRONIZER = new Object();
    private String[] addInFunctionNames;
    static /* synthetic */ Class class$jxl$write$biff$WritableWorkbookImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WritableWorkbookImpl(OutputStream outputStream, boolean bl, WorkbookSettings workbookSettings) throws IOException {
        this.outputFile = new File(outputStream, workbookSettings, null);
        this.sheets = new ArrayList();
        this.sharedStrings = new SharedStrings();
        this.nameRecords = new HashMap();
        this.closeStream = bl;
        this.wbProtected = false;
        this.containsMacros = false;
        this.settings = workbookSettings;
        this.rcirCells = new ArrayList();
        this.styles = new Styles();
        Object object = SYNCHRONIZER;
        synchronized (object) {
            WritableWorkbook.ARIAL_10_PT.uninitialize();
            WritableWorkbook.HYPERLINK_FONT.uninitialize();
            WritableWorkbook.NORMAL_STYLE.uninitialize();
            WritableWorkbook.HYPERLINK_STYLE.uninitialize();
            WritableWorkbook.HIDDEN_STYLE.uninitialize();
            DateRecord.defaultDateFormat.uninitialize();
        }
        this.fonts = object = new WritableFonts(this);
        WritableFormattingRecords writableFormattingRecords = new WritableFormattingRecords(this.fonts, this.styles);
        this.formatRecords = writableFormattingRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WritableWorkbookImpl(OutputStream outputStream, Workbook workbook, boolean bl, WorkbookSettings workbookSettings) throws IOException {
        WorkbookParser workbookParser = (WorkbookParser)workbook;
        RecordData[] recordDataArray = SYNCHRONIZER;
        synchronized (SYNCHRONIZER) {
            RecordData recordData;
            int n;
            block15: {
                WritableWorkbook.ARIAL_10_PT.uninitialize();
                WritableWorkbook.HYPERLINK_FONT.uninitialize();
                WritableWorkbook.NORMAL_STYLE.uninitialize();
                WritableWorkbook.HYPERLINK_STYLE.uninitialize();
                WritableWorkbook.HIDDEN_STYLE.uninitialize();
                DateRecord.defaultDateFormat.uninitialize();
                // ** MonitorExit[var6_6] (shouldn't be in output)
                this.closeStream = bl;
                this.sheets = new ArrayList();
                this.sharedStrings = new SharedStrings();
                this.nameRecords = new HashMap();
                this.fonts = workbookParser.getFonts();
                this.formatRecords = workbookParser.getFormattingRecords();
                this.wbProtected = false;
                this.settings = workbookSettings;
                this.rcirCells = new ArrayList();
                this.styles = new Styles();
                this.outputFile = new File(outputStream, workbookSettings, workbookParser.getCompoundFile());
                this.containsMacros = false;
                if (!workbookSettings.getPropertySetsDisabled()) {
                    this.containsMacros = workbookParser.containsMacros();
                }
                if (workbookParser.getCountryRecord() != null) {
                    this.countryRecord = new CountryRecord(workbookParser.getCountryRecord());
                }
                this.addInFunctionNames = workbookParser.getAddInFunctionNames();
                if (workbookParser.getExternalSheetRecord() == null) break block15;
                this.externSheet = new ExternalSheetRecord(workbookParser.getExternalSheetRecord());
                recordDataArray = workbookParser.getSupbookRecords();
                this.supbooks = new ArrayList(recordDataArray.length);
                for (n = 0; n < recordDataArray.length; ++n) {
                    block17: {
                        block16: {
                            recordData = recordDataArray[n];
                            if (((jxl.read.biff.SupbookRecord)recordData).getType() == jxl.read.biff.SupbookRecord.INTERNAL) break block16;
                            if (((jxl.read.biff.SupbookRecord)recordData).getType() != jxl.read.biff.SupbookRecord.EXTERNAL) break block17;
                        }
                        this.supbooks.add(new SupbookRecord((jxl.read.biff.SupbookRecord)recordData, this.settings));
                        continue;
                    }
                    if (((jxl.read.biff.SupbookRecord)recordData).getType() == jxl.read.biff.SupbookRecord.ADDIN) continue;
                    logger.warn("unsupported supbook type - ignoring");
                }
            }
            if (workbookParser.getDrawingGroup() != null) {
                this.drawingGroup = new DrawingGroup(workbookParser.getDrawingGroup());
            }
            if (this.containsMacros && workbookParser.getButtonPropertySet() != null) {
                this.buttonPropertySet = new ButtonPropertySetRecord(workbookParser.getButtonPropertySet());
            }
            if (!this.settings.getNamesDisabled()) {
                recordDataArray = workbookParser.getNameRecords();
                this.names = new ArrayList(recordDataArray.length);
                for (n = 0; n < recordDataArray.length; ++n) {
                    if (((jxl.read.biff.NameRecord)recordDataArray[n]).isBiff8()) {
                        recordData = new NameRecord((jxl.read.biff.NameRecord)recordDataArray[n], n);
                        this.names.add(recordData);
                        String string = ((NameRecord)recordData).getName();
                        this.nameRecords.put(string, recordData);
                        continue;
                    }
                    logger.warn("Cannot copy Biff7 name records - ignoring");
                }
            }
            this.copyWorkbook(workbook);
            if (this.drawingGroup != null) {
                this.drawingGroup.updateData(workbookParser.getDrawingGroup());
            }
            return;
        }
    }

    public WritableSheet[] getSheets() {
        WritableSheet[] writableSheetArray = new WritableSheet[this.getNumberOfSheets()];
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            writableSheetArray[i] = this.getSheet(i);
        }
        return writableSheetArray;
    }

    public String[] getSheetNames() {
        String[] stringArray = new String[this.getNumberOfSheets()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getSheet(i).getName();
        }
        return stringArray;
    }

    public Sheet getReadSheet(int n) {
        return this.getSheet(n);
    }

    public WritableSheet getSheet(int n) {
        return (WritableSheet)this.sheets.get(n);
    }

    public WritableSheet getSheet(String string) {
        boolean bl = false;
        Iterator iterator = this.sheets.iterator();
        WritableSheet writableSheet = null;
        while (iterator.hasNext() && !bl) {
            writableSheet = (WritableSheet)iterator.next();
            if (!writableSheet.getName().equals(string)) continue;
            bl = true;
        }
        return bl ? writableSheet : null;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public void close() throws IOException, JxlWriteException {
        this.outputFile.close(this.closeStream);
    }

    public void setOutputFile(java.io.File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.outputFile.setOutputFile(fileOutputStream);
    }

    private WritableSheet createSheet(String string, int n, boolean bl) {
        SupbookRecord supbookRecord;
        WritableSheetImpl writableSheetImpl = new WritableSheetImpl(string, this.outputFile, this.formatRecords, this.sharedStrings, this.settings, this);
        int n2 = n;
        if (n <= 0) {
            n2 = 0;
            this.sheets.add(0, writableSheetImpl);
        } else if (n > this.sheets.size()) {
            n2 = this.sheets.size();
            this.sheets.add(writableSheetImpl);
        } else {
            this.sheets.add(n, writableSheetImpl);
        }
        if (bl && this.externSheet != null) {
            this.externSheet.sheetInserted(n2);
        }
        if (this.supbooks != null && this.supbooks.size() > 0 && (supbookRecord = (SupbookRecord)this.supbooks.get(0)).getType() == SupbookRecord.INTERNAL) {
            supbookRecord.adjustInternal(this.sheets.size());
        }
        return writableSheetImpl;
    }

    public WritableSheet createSheet(String string, int n) {
        return this.createSheet(string, n, true);
    }

    public void removeSheet(int n) {
        SupbookRecord supbookRecord;
        int n2 = n;
        if (n <= 0) {
            n2 = 0;
            this.sheets.remove(0);
        } else if (n >= this.sheets.size()) {
            n2 = this.sheets.size() - 1;
            this.sheets.remove(this.sheets.size() - 1);
        } else {
            this.sheets.remove(n);
        }
        if (this.externSheet != null) {
            this.externSheet.sheetRemoved(n2);
        }
        if (this.supbooks != null && this.supbooks.size() > 0 && (supbookRecord = (SupbookRecord)this.supbooks.get(0)).getType() == SupbookRecord.INTERNAL) {
            supbookRecord.adjustInternal(this.sheets.size());
        }
        if (this.names != null && this.names.size() > 0) {
            for (int i = 0; i < this.names.size(); ++i) {
                NameRecord nameRecord = (NameRecord)this.names.get(i);
                int n3 = nameRecord.getSheetRef();
                if (n3 == n2 + 1) {
                    nameRecord.setSheetRef(0);
                    continue;
                }
                if (n3 <= n2 + 1) continue;
                if (n3 < 1) {
                    n3 = 1;
                }
                nameRecord.setSheetRef(n3 - 1);
            }
        }
    }

    public WritableSheet moveSheet(int n, int n2) {
        n = Math.max(n, 0);
        n = Math.min(n, this.sheets.size() - 1);
        n2 = Math.max(n2, 0);
        n2 = Math.min(n2, this.sheets.size() - 1);
        WritableSheet writableSheet = (WritableSheet)this.sheets.remove(n);
        this.sheets.add(n2, writableSheet);
        return writableSheet;
    }

    public void write() throws IOException {
        Object object;
        int n;
        WritableRecordData writableRecordData;
        Object object2;
        Object object3;
        Object object4;
        WritableSheetImpl writableSheetImpl = null;
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            writableSheetImpl = (WritableSheetImpl)this.getSheet(i);
            writableSheetImpl.checkMergedBorders();
            object4 = writableSheetImpl.getSettings().getPrintArea();
            if (object4 != null) {
                this.addNameArea(BuiltInName.PRINT_AREA, (WritableSheet)writableSheetImpl, object4.getTopLeft().getColumn(), object4.getTopLeft().getRow(), object4.getBottomRight().getColumn(), object4.getBottomRight().getRow(), false);
            }
            object3 = writableSheetImpl.getSettings().getPrintTitlesRow();
            object2 = writableSheetImpl.getSettings().getPrintTitlesCol();
            if (object3 != null && object2 != null) {
                this.addNameArea(BuiltInName.PRINT_TITLES, writableSheetImpl, object3.getTopLeft().getColumn(), object3.getTopLeft().getRow(), object3.getBottomRight().getColumn(), object3.getBottomRight().getRow(), object2.getTopLeft().getColumn(), object2.getTopLeft().getRow(), object2.getBottomRight().getColumn(), object2.getBottomRight().getRow(), false);
                continue;
            }
            if (object3 != null) {
                this.addNameArea(BuiltInName.PRINT_TITLES, (WritableSheet)writableSheetImpl, object3.getTopLeft().getColumn(), object3.getTopLeft().getRow(), object3.getBottomRight().getColumn(), object3.getBottomRight().getRow(), false);
                continue;
            }
            if (object2 == null) continue;
            this.addNameArea(BuiltInName.PRINT_TITLES, (WritableSheet)writableSheetImpl, object2.getTopLeft().getColumn(), object2.getTopLeft().getRow(), object2.getBottomRight().getColumn(), object2.getBottomRight().getRow(), false);
        }
        if (!this.settings.getRationalizationDisabled()) {
            this.rationalize();
        }
        BOFRecord bOFRecord = new BOFRecord(BOFRecord.workbookGlobals);
        this.outputFile.write(bOFRecord);
        object4 = new InterfaceHeaderRecord();
        this.outputFile.write((ByteData)object4);
        object3 = new MMSRecord(0, 0);
        this.outputFile.write((ByteData)object3);
        object2 = new InterfaceEndRecord();
        this.outputFile.write((ByteData)object2);
        WriteAccessRecord writeAccessRecord = new WriteAccessRecord();
        this.outputFile.write(writeAccessRecord);
        CodepageRecord codepageRecord = new CodepageRecord();
        this.outputFile.write(codepageRecord);
        DSFRecord dSFRecord = new DSFRecord();
        this.outputFile.write(dSFRecord);
        TabIdRecord tabIdRecord = new TabIdRecord(this.getNumberOfSheets());
        this.outputFile.write(tabIdRecord);
        if (this.containsMacros) {
            writableRecordData = new ObjProjRecord();
            this.outputFile.write(writableRecordData);
        }
        if (this.buttonPropertySet != null) {
            this.outputFile.write(this.buttonPropertySet);
        }
        writableRecordData = new FunctionGroupCountRecord();
        this.outputFile.write(writableRecordData);
        WindowProtectRecord windowProtectRecord = new WindowProtectRecord(false);
        this.outputFile.write(windowProtectRecord);
        ProtectRecord protectRecord = new ProtectRecord(this.wbProtected);
        this.outputFile.write(protectRecord);
        PasswordRecord passwordRecord = new PasswordRecord(null);
        this.outputFile.write(passwordRecord);
        Prot4RevRecord prot4RevRecord = new Prot4RevRecord(false);
        this.outputFile.write(prot4RevRecord);
        Prot4RevPassRecord prot4RevPassRecord = new Prot4RevPassRecord();
        this.outputFile.write(prot4RevPassRecord);
        boolean bl = false;
        WritableSheetImpl writableSheetImpl2 = null;
        int n2 = 0;
        for (int i = 0; i < this.getNumberOfSheets() && !bl; ++i) {
            writableSheetImpl2 = (WritableSheetImpl)this.getSheet(i);
            if (!writableSheetImpl2.getSettings().isSelected()) continue;
            bl = true;
            n2 = i;
        }
        if (!bl) {
            writableSheetImpl2 = (WritableSheetImpl)this.getSheet(0);
            writableSheetImpl2.getSettings().setSelected(true);
            n2 = 0;
        }
        Window1Record window1Record = new Window1Record(n2);
        this.outputFile.write(window1Record);
        BackupRecord backupRecord = new BackupRecord(false);
        this.outputFile.write(backupRecord);
        HideobjRecord hideobjRecord = new HideobjRecord(false);
        this.outputFile.write(hideobjRecord);
        NineteenFourRecord nineteenFourRecord = new NineteenFourRecord(false);
        this.outputFile.write(nineteenFourRecord);
        PrecisionRecord precisionRecord = new PrecisionRecord(false);
        this.outputFile.write(precisionRecord);
        RefreshAllRecord refreshAllRecord = new RefreshAllRecord(false);
        this.outputFile.write(refreshAllRecord);
        BookboolRecord bookboolRecord = new BookboolRecord(true);
        this.outputFile.write(bookboolRecord);
        this.fonts.write(this.outputFile);
        this.formatRecords.write(this.outputFile);
        if (this.formatRecords.getPalette() != null) {
            this.outputFile.write(this.formatRecords.getPalette());
        }
        UsesElfsRecord usesElfsRecord = new UsesElfsRecord();
        this.outputFile.write(usesElfsRecord);
        int[] nArray = new int[this.getNumberOfSheets()];
        WritableSheet writableSheet = null;
        for (n = 0; n < this.getNumberOfSheets(); ++n) {
            nArray[n] = this.outputFile.getPos();
            writableSheet = this.getSheet(n);
            object = new BoundsheetRecord(writableSheet.getName());
            if (writableSheet.getSettings().isHidden()) {
                ((BoundsheetRecord)object).setHidden();
            }
            if (((WritableSheetImpl)this.sheets.get(n)).isChartOnly()) {
                ((BoundsheetRecord)object).setChartOnly();
            }
            this.outputFile.write((ByteData)object);
        }
        if (this.countryRecord == null) {
            CountryCode countryCode = CountryCode.getCountryCode(this.settings.getExcelDisplayLanguage());
            if (countryCode == CountryCode.UNKNOWN) {
                logger.warn("Unknown country code " + this.settings.getExcelDisplayLanguage() + " using " + CountryCode.USA.getCode());
                countryCode = CountryCode.USA;
            }
            object = CountryCode.getCountryCode(this.settings.getExcelRegionalSettings());
            this.countryRecord = new CountryRecord(countryCode, (CountryCode)object);
            if (object == CountryCode.UNKNOWN) {
                logger.warn("Unknown country code " + this.settings.getExcelDisplayLanguage() + " using " + CountryCode.UK.getCode());
                object = CountryCode.UK;
            }
        }
        this.outputFile.write(this.countryRecord);
        if (this.addInFunctionNames != null && this.addInFunctionNames.length > 0) {
            SupbookRecord supbookRecord = new SupbookRecord();
            this.outputFile.write(supbookRecord);
            for (int i = 0; i < this.addInFunctionNames.length; ++i) {
                ExternalNameRecord externalNameRecord = new ExternalNameRecord(this.addInFunctionNames[i]);
                this.outputFile.write(externalNameRecord);
            }
        }
        if (this.externSheet != null) {
            for (n = 0; n < this.supbooks.size(); ++n) {
                SupbookRecord supbookRecord = (SupbookRecord)this.supbooks.get(n);
                this.outputFile.write(supbookRecord);
            }
            this.outputFile.write(this.externSheet);
        }
        if (this.names != null) {
            for (n = 0; n < this.names.size(); ++n) {
                NameRecord nameRecord = (NameRecord)this.names.get(n);
                this.outputFile.write(nameRecord);
            }
        }
        if (this.drawingGroup != null) {
            this.drawingGroup.write(this.outputFile);
        }
        this.sharedStrings.write(this.outputFile);
        EOFRecord eOFRecord = new EOFRecord();
        this.outputFile.write(eOFRecord);
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            this.outputFile.setData(IntegerHelper.getFourBytes(this.outputFile.getPos()), nArray[i] + 4);
            writableSheetImpl2 = (WritableSheetImpl)this.getSheet(i);
            writableSheetImpl2.write();
        }
    }

    private void copyWorkbook(Workbook workbook) {
        int n = workbook.getNumberOfSheets();
        this.wbProtected = workbook.isProtected();
        Sheet sheet = null;
        WritableSheetImpl writableSheetImpl = null;
        for (int i = 0; i < n; ++i) {
            sheet = workbook.getSheet(i);
            writableSheetImpl = (WritableSheetImpl)this.createSheet(sheet.getName(), i, false);
            writableSheetImpl.copy(sheet);
        }
    }

    public void copySheet(int n, String string, int n2) {
        WritableSheet writableSheet = this.getSheet(n);
        WritableSheetImpl writableSheetImpl = (WritableSheetImpl)this.createSheet(string, n2);
        writableSheetImpl.copy(writableSheet);
    }

    public void copySheet(String string, String string2, int n) {
        WritableSheet writableSheet = this.getSheet(string);
        WritableSheetImpl writableSheetImpl = (WritableSheetImpl)this.createSheet(string2, n);
        writableSheetImpl.copy(writableSheet);
    }

    public void setProtected(boolean bl) {
        this.wbProtected = bl;
    }

    private void rationalize() {
        IndexMapping indexMapping = this.formatRecords.rationalizeFonts();
        IndexMapping indexMapping2 = this.formatRecords.rationalizeDisplayFormats();
        IndexMapping indexMapping3 = this.formatRecords.rationalize(indexMapping, indexMapping2);
        WritableSheetImpl writableSheetImpl = null;
        for (int i = 0; i < this.sheets.size(); ++i) {
            writableSheetImpl = (WritableSheetImpl)this.sheets.get(i);
            writableSheetImpl.rationalize(indexMapping3, indexMapping, indexMapping2);
        }
    }

    private int getInternalSheetIndex(String string) {
        int n = -1;
        String[] stringArray = this.getSheetNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    public String getExternalSheetName(int n) {
        int n2 = this.externSheet.getSupbookIndex(n);
        SupbookRecord supbookRecord = (SupbookRecord)this.supbooks.get(n2);
        int n3 = this.externSheet.getFirstTabIndex(n);
        if (supbookRecord.getType() == SupbookRecord.INTERNAL) {
            WritableSheet writableSheet = this.getSheet(n3);
            return writableSheet.getName();
        }
        if (supbookRecord.getType() == SupbookRecord.EXTERNAL) {
            String string = supbookRecord.getFileName() + supbookRecord.getSheetName(n3);
            return string;
        }
        return "[UNKNOWN]";
    }

    public String getLastExternalSheetName(int n) {
        int n2 = this.externSheet.getSupbookIndex(n);
        SupbookRecord supbookRecord = (SupbookRecord)this.supbooks.get(n2);
        int n3 = this.externSheet.getLastTabIndex(n);
        if (supbookRecord.getType() == SupbookRecord.INTERNAL) {
            WritableSheet writableSheet = this.getSheet(n3);
            return writableSheet.getName();
        }
        if (supbookRecord.getType() == SupbookRecord.EXTERNAL) {
            Assert.verify(false);
        }
        return "[UNKNOWN]";
    }

    public jxl.read.biff.BOFRecord getWorkbookBof() {
        return null;
    }

    public int getExternalSheetIndex(int n) {
        if (this.externSheet == null) {
            return n;
        }
        Assert.verify(this.externSheet != null);
        int n2 = this.externSheet.getFirstTabIndex(n);
        return n2;
    }

    public int getLastExternalSheetIndex(int n) {
        if (this.externSheet == null) {
            return n;
        }
        Assert.verify(this.externSheet != null);
        int n2 = this.externSheet.getLastTabIndex(n);
        return n2;
    }

    public int getExternalSheetIndex(String string) {
        int n;
        if (this.externSheet == null) {
            this.externSheet = new ExternalSheetRecord();
            this.supbooks = new ArrayList();
            this.supbooks.add(new SupbookRecord(this.getNumberOfSheets(), this.settings));
        }
        boolean bl = false;
        Iterator iterator = this.sheets.iterator();
        int n2 = 0;
        WritableSheetImpl writableSheetImpl = null;
        while (iterator.hasNext() && !bl) {
            writableSheetImpl = (WritableSheetImpl)iterator.next();
            if (writableSheetImpl.getName().equals(string)) {
                bl = true;
                continue;
            }
            ++n2;
        }
        if (bl) {
            SupbookRecord supbookRecord = (SupbookRecord)this.supbooks.get(0);
            if (supbookRecord.getType() != SupbookRecord.INTERNAL || supbookRecord.getNumberOfSheets() != this.getNumberOfSheets()) {
                logger.warn("Cannot find sheet " + string + " in supbook record");
            }
            return this.externSheet.getIndex(0, n2);
        }
        int n3 = string.lastIndexOf(93);
        int n4 = string.lastIndexOf(91);
        if (n3 == -1 || n4 == -1) {
            return -1;
        }
        String string2 = string.substring(n3 + 1);
        String string3 = string.substring(n4 + 1, n3);
        String string4 = string.substring(0, n4);
        String string5 = string4 + string3;
        boolean bl2 = false;
        SupbookRecord supbookRecord = null;
        int n5 = -1;
        for (n = 0; n < this.supbooks.size() && !bl2; ++n) {
            supbookRecord = (SupbookRecord)this.supbooks.get(n);
            if (supbookRecord.getType() != SupbookRecord.EXTERNAL || !supbookRecord.getFileName().equals(string5)) continue;
            bl2 = true;
            n5 = n;
        }
        if (!bl2) {
            supbookRecord = new SupbookRecord(string5, this.settings);
            n5 = this.supbooks.size();
            this.supbooks.add(supbookRecord);
        }
        n = supbookRecord.getSheetIndex(string2);
        return this.externSheet.getIndex(n5, n);
    }

    public int getLastExternalSheetIndex(String string) {
        if (this.externSheet == null) {
            this.externSheet = new ExternalSheetRecord();
            this.supbooks = new ArrayList();
            this.supbooks.add(new SupbookRecord(this.getNumberOfSheets(), this.settings));
        }
        boolean bl = false;
        Iterator iterator = this.sheets.iterator();
        int n = 0;
        WritableSheetImpl writableSheetImpl = null;
        while (iterator.hasNext() && !bl) {
            writableSheetImpl = (WritableSheetImpl)iterator.next();
            if (writableSheetImpl.getName().equals(string)) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (!bl) {
            return -1;
        }
        SupbookRecord supbookRecord = (SupbookRecord)this.supbooks.get(0);
        Assert.verify(supbookRecord.getType() == SupbookRecord.INTERNAL && supbookRecord.getNumberOfSheets() == this.getNumberOfSheets());
        return this.externSheet.getIndex(0, n);
    }

    public void setColourRGB(Colour colour, int n, int n2, int n3) {
        this.formatRecords.setColourRGB(colour, n, n2, n3);
    }

    public RGB getColourRGB(Colour colour) {
        return this.formatRecords.getColourRGB(colour);
    }

    public String getName(int n) {
        Assert.verify(n >= 0 && n < this.names.size());
        NameRecord nameRecord = (NameRecord)this.names.get(n);
        return nameRecord.getName();
    }

    public int getNameIndex(String string) {
        NameRecord nameRecord = (NameRecord)this.nameRecords.get(string);
        return nameRecord != null ? nameRecord.getIndex() : -1;
    }

    void addRCIRCell(CellValue cellValue) {
        this.rcirCells.add(cellValue);
    }

    void columnInserted(WritableSheetImpl writableSheetImpl, int n) {
        WritableRecordData writableRecordData;
        int n2 = this.getExternalSheetIndex(writableSheetImpl.getName());
        Iterator iterator = this.rcirCells.iterator();
        while (iterator.hasNext()) {
            writableRecordData = (CellValue)iterator.next();
            ((CellValue)writableRecordData).columnInserted(writableSheetImpl, n2, n);
        }
        if (this.names != null) {
            iterator = this.names.iterator();
            while (iterator.hasNext()) {
                writableRecordData = (NameRecord)iterator.next();
                ((NameRecord)writableRecordData).columnInserted(n2, n);
            }
        }
    }

    void columnRemoved(WritableSheetImpl writableSheetImpl, int n) {
        Iterator iterator;
        int n2 = this.getExternalSheetIndex(writableSheetImpl.getName());
        Object object = this.rcirCells.iterator();
        while (object.hasNext()) {
            iterator = (CellValue)object.next();
            ((CellValue)((Object)iterator)).columnRemoved(writableSheetImpl, n2, n);
        }
        object = new ArrayList();
        if (this.names != null) {
            boolean bl;
            NameRecord nameRecord;
            iterator = this.names.iterator();
            while (iterator.hasNext()) {
                nameRecord = (NameRecord)iterator.next();
                bl = nameRecord.columnRemoved(n2, n);
                if (!bl) continue;
                ((ArrayList)object).add(nameRecord);
            }
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                nameRecord = (NameRecord)iterator.next();
                bl = this.names.remove(nameRecord);
                Assert.verify(bl, "Could not remove name " + nameRecord.getName());
            }
        }
    }

    void rowInserted(WritableSheetImpl writableSheetImpl, int n) {
        WritableRecordData writableRecordData;
        int n2 = this.getExternalSheetIndex(writableSheetImpl.getName());
        Iterator iterator = this.rcirCells.iterator();
        while (iterator.hasNext()) {
            writableRecordData = (CellValue)iterator.next();
            ((CellValue)writableRecordData).rowInserted(writableSheetImpl, n2, n);
        }
        if (this.names != null) {
            iterator = this.names.iterator();
            while (iterator.hasNext()) {
                writableRecordData = (NameRecord)iterator.next();
                ((NameRecord)writableRecordData).rowInserted(n2, n);
            }
        }
    }

    void rowRemoved(WritableSheetImpl writableSheetImpl, int n) {
        Iterator iterator;
        int n2 = this.getExternalSheetIndex(writableSheetImpl.getName());
        Object object = this.rcirCells.iterator();
        while (object.hasNext()) {
            iterator = (CellValue)object.next();
            ((CellValue)((Object)iterator)).rowRemoved(writableSheetImpl, n2, n);
        }
        object = new ArrayList();
        if (this.names != null) {
            boolean bl;
            NameRecord nameRecord;
            iterator = this.names.iterator();
            while (iterator.hasNext()) {
                nameRecord = (NameRecord)iterator.next();
                bl = nameRecord.rowRemoved(n2, n);
                if (!bl) continue;
                ((ArrayList)object).add(nameRecord);
            }
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                nameRecord = (NameRecord)iterator.next();
                bl = this.names.remove(nameRecord);
                Assert.verify(bl, "Could not remove name " + nameRecord.getName());
            }
        }
    }

    public WritableCell findCellByName(String string) {
        NameRecord nameRecord = (NameRecord)this.nameRecords.get(string);
        if (nameRecord == null) {
            return null;
        }
        NameRecord.NameRange[] nameRangeArray = nameRecord.getRanges();
        int n = this.getExternalSheetIndex(nameRangeArray[0].getExternalSheet());
        WritableSheet writableSheet = this.getSheet(n);
        WritableCell writableCell = writableSheet.getWritableCell(nameRangeArray[0].getFirstColumn(), nameRangeArray[0].getFirstRow());
        return writableCell;
    }

    public Range[] findByName(String string) {
        NameRecord nameRecord = (NameRecord)this.nameRecords.get(string);
        if (nameRecord == null) {
            return null;
        }
        NameRecord.NameRange[] nameRangeArray = nameRecord.getRanges();
        Range[] rangeArray = new Range[nameRangeArray.length];
        for (int i = 0; i < nameRangeArray.length; ++i) {
            rangeArray[i] = new RangeImpl(this, this.getExternalSheetIndex(nameRangeArray[i].getExternalSheet()), nameRangeArray[i].getFirstColumn(), nameRangeArray[i].getFirstRow(), this.getLastExternalSheetIndex(nameRangeArray[i].getExternalSheet()), nameRangeArray[i].getLastColumn(), nameRangeArray[i].getLastRow());
        }
        return rangeArray;
    }

    void addDrawing(DrawingGroupObject drawingGroupObject) {
        if (this.drawingGroup == null) {
            this.drawingGroup = new DrawingGroup(Origin.WRITE);
        }
        this.drawingGroup.add(drawingGroupObject);
    }

    void removeDrawing(Drawing drawing) {
        Assert.verify(this.drawingGroup != null);
        this.drawingGroup.remove(drawing);
    }

    DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    DrawingGroup createDrawingGroup() {
        if (this.drawingGroup == null) {
            this.drawingGroup = new DrawingGroup(Origin.WRITE);
        }
        return this.drawingGroup;
    }

    public String[] getRangeNames() {
        if (this.names == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.names.size()];
        for (int i = 0; i < this.names.size(); ++i) {
            NameRecord nameRecord = (NameRecord)this.names.get(i);
            stringArray[i] = nameRecord.getName();
        }
        return stringArray;
    }

    public void removeRangeName(String string) {
        int n = 0;
        boolean bl = false;
        Iterator iterator = this.names.iterator();
        while (iterator.hasNext() && !bl) {
            NameRecord nameRecord = (NameRecord)iterator.next();
            if (nameRecord.getName().equals(string)) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            this.names.remove(n);
            if (this.nameRecords.remove(string) == null) {
                logger.warn("Could not remove " + string + " from index lookups");
            }
        }
    }

    Styles getStyles() {
        return this.styles;
    }

    public void addNameArea(String string, WritableSheet writableSheet, int n, int n2, int n3, int n4) {
        this.addNameArea(string, writableSheet, n, n2, n3, n4, true);
    }

    void addNameArea(String string, WritableSheet writableSheet, int n, int n2, int n3, int n4, boolean bl) {
        if (this.names == null) {
            this.names = new ArrayList();
        }
        int n5 = this.getExternalSheetIndex(writableSheet.getName());
        NameRecord nameRecord = new NameRecord(string, this.names.size(), n5, n2, n4, n, n3, bl);
        this.names.add(nameRecord);
        this.nameRecords.put(string, nameRecord);
    }

    void addNameArea(BuiltInName builtInName, WritableSheet writableSheet, int n, int n2, int n3, int n4, boolean bl) {
        if (this.names == null) {
            this.names = new ArrayList();
        }
        int n5 = this.getInternalSheetIndex(writableSheet.getName());
        int n6 = this.getExternalSheetIndex(writableSheet.getName());
        NameRecord nameRecord = new NameRecord(builtInName, n5, n6, n2, n4, n, n3, bl);
        this.names.add(nameRecord);
        this.nameRecords.put(builtInName, nameRecord);
    }

    void addNameArea(BuiltInName builtInName, WritableSheet writableSheet, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        if (this.names == null) {
            this.names = new ArrayList();
        }
        int n9 = this.getInternalSheetIndex(writableSheet.getName());
        int n10 = this.getExternalSheetIndex(writableSheet.getName());
        NameRecord nameRecord = new NameRecord(builtInName, n9, n10, n6, n8, n5, n7, n2, n4, n, n3, bl);
        this.names.add(nameRecord);
        this.nameRecords.put(builtInName, nameRecord);
    }

    WorkbookSettings getSettings() {
        return this.settings;
    }

    public WritableCell getWritableCell(String string) {
        WritableSheet writableSheet = this.getSheet(CellReferenceHelper.getSheet(string));
        return writableSheet.getWritableCell(string);
    }

    public WritableSheet importSheet(String string, int n, Sheet sheet) {
        WritableSheet writableSheet = this.createSheet(string, n);
        ((WritableSheetImpl)writableSheet).importSheet(sheet);
        return writableSheet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

