/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class SSTContinueRecord
extends WritableRecordData {
    private String firstString;
    private boolean includeLength;
    private int firstStringLength;
    private ArrayList strings = new ArrayList(50);
    private ArrayList stringLengths = new ArrayList(50);
    private byte[] data;
    private int byteCount = 0;
    private static int maxBytes = 8224;

    public SSTContinueRecord() {
        super(Type.CONTINUE);
    }

    public int setFirstString(String string, boolean bl) {
        this.includeLength = bl;
        this.firstStringLength = string.length();
        int n = 0;
        n = !this.includeLength ? string.length() * 2 + 1 : string.length() * 2 + 3;
        if (n <= maxBytes) {
            this.firstString = string;
            this.byteCount += n;
            return 0;
        }
        int n2 = this.includeLength ? (maxBytes - 4) / 2 : (maxBytes - 2) / 2;
        this.firstString = string.substring(0, n2);
        this.byteCount = maxBytes - 1;
        return string.length() - n2;
    }

    public int getOffset() {
        return this.byteCount;
    }

    public int add(String string) {
        int n = string.length() * 2 + 3;
        if (this.byteCount >= maxBytes - 5) {
            return string.length();
        }
        this.stringLengths.add(new Integer(string.length()));
        if (n + this.byteCount < maxBytes) {
            this.strings.add(string);
            this.byteCount += n;
            return 0;
        }
        int n2 = maxBytes - 3 - this.byteCount;
        int n3 = n2 % 2 == 0 ? n2 / 2 : (n2 - 1) / 2;
        this.strings.add(string.substring(0, n3));
        this.byteCount += n3 * 2 + 3;
        return string.length() - n3;
    }

    public byte[] getData() {
        this.data = new byte[this.byteCount];
        int n = 0;
        if (this.includeLength) {
            IntegerHelper.getTwoBytes(this.firstStringLength, this.data, 0);
            this.data[2] = 1;
            n = 3;
        } else {
            this.data[0] = 1;
            n = 1;
        }
        StringHelper.getUnicodeBytes(this.firstString, this.data, n);
        n += this.firstString.length() * 2;
        Iterator iterator = this.strings.iterator();
        String string = null;
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            n2 = (Integer)this.stringLengths.get(n3);
            IntegerHelper.getTwoBytes(n2, this.data, n);
            this.data[n + 2] = 1;
            StringHelper.getUnicodeBytes(string, this.data, n + 3);
            n += string.length() * 2 + 3;
            ++n3;
        }
        return this.data;
    }
}

