/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import jxl.biff.BuiltInName;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.NameRecord;

class NameRecord
extends WritableRecordData {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$NameRecord == null ? (class$jxl$write$biff$NameRecord = NameRecord.class$("jxl.write.biff.NameRecord")) : class$jxl$write$biff$NameRecord);
    private byte[] data;
    private String name;
    private BuiltInName builtInName;
    private int index;
    private int sheetRef = 0;
    private boolean modified;
    private NameRange[] ranges;
    private static final int cellReference = 58;
    private static final int areaReference = 59;
    private static final int subExpression = 41;
    private static final int union = 16;
    private static final NameRange EMPTY_RANGE = new NameRange(0, 0, 0, 0, 0);
    static /* synthetic */ Class class$jxl$write$biff$NameRecord;

    public NameRecord(jxl.read.biff.NameRecord nameRecord, int n) {
        super(Type.NAME);
        this.data = nameRecord.getData();
        this.name = nameRecord.getName();
        this.sheetRef = nameRecord.getSheetRef();
        this.index = n;
        this.modified = false;
        NameRecord.NameRange[] nameRangeArray = nameRecord.getRanges();
        this.ranges = new NameRange[nameRangeArray.length];
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i] = new NameRange(nameRangeArray[i]);
        }
    }

    NameRecord(String string, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(Type.NAME);
        this.name = string;
        this.index = n;
        this.sheetRef = bl ? 0 : this.index + 1;
        this.ranges = new NameRange[1];
        this.ranges[0] = new NameRange(n2, n3, n4, n5, n6);
        this.modified = true;
    }

    NameRecord(BuiltInName builtInName, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(Type.NAME);
        this.builtInName = builtInName;
        this.index = n;
        this.sheetRef = bl ? 0 : this.index + 1;
        this.ranges = new NameRange[1];
        this.ranges[0] = new NameRange(n2, n3, n4, n5, n6);
    }

    NameRecord(BuiltInName builtInName, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
        super(Type.NAME);
        this.builtInName = builtInName;
        this.index = n;
        this.sheetRef = bl ? 0 : this.index + 1;
        this.ranges = new NameRange[2];
        this.ranges[0] = new NameRange(n2, n3, n4, n5, n6);
        this.ranges[1] = new NameRange(n2, n7, n8, n9, n10);
    }

    public byte[] getData() {
        int n;
        if (this.data != null && !this.modified) {
            return this.data;
        }
        int n2 = this.ranges.length > 1 ? this.ranges.length * 11 + 4 : 11;
        int n3 = 15 + n2;
        this.data = new byte[n3 += this.builtInName != null ? 1 : this.name.length()];
        int n4 = 0;
        if (this.builtInName != null) {
            n4 |= 0x20;
        }
        IntegerHelper.getTwoBytes(n4, this.data, 0);
        this.data[2] = 0;
        this.data[3] = this.builtInName != null ? (byte)1 : (byte)this.name.length();
        IntegerHelper.getTwoBytes(n2, this.data, 4);
        IntegerHelper.getTwoBytes(this.sheetRef, this.data, 6);
        IntegerHelper.getTwoBytes(this.sheetRef, this.data, 8);
        if (this.builtInName != null) {
            this.data[15] = (byte)this.builtInName.getValue();
        } else {
            StringHelper.getBytes(this.name, this.data, 15);
        }
        int n5 = n = this.builtInName != null ? 16 : this.name.length() + 15;
        if (this.ranges.length > 1) {
            this.data[n++] = 41;
            IntegerHelper.getTwoBytes(n2 - 3, this.data, n);
            n += 2;
            for (int i = 0; i < this.ranges.length; ++i) {
                this.data[n++] = 59;
                byte[] byArray = this.ranges[i].getData();
                System.arraycopy(byArray, 0, this.data, n, byArray.length);
                n += byArray.length;
            }
            this.data[n] = 16;
        } else {
            this.data[n] = 59;
            byte[] byArray = this.ranges[0].getData();
            System.arraycopy(byArray, 0, this.data, n + 1, byArray.length);
        }
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSheetRef() {
        return this.sheetRef;
    }

    public void setSheetRef(int n) {
        this.sheetRef = n;
        IntegerHelper.getTwoBytes(this.sheetRef, this.data, 8);
    }

    public NameRange[] getRanges() {
        return this.ranges;
    }

    void rowInserted(int n, int n2) {
        if (n != this.sheetRef) {
            return;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            if (n2 <= this.ranges[i].getFirstRow()) {
                this.ranges[i].incrementFirstRow();
                this.modified = true;
            }
            if (n2 > this.ranges[i].getLastRow()) continue;
            this.ranges[i].incrementLastRow();
            this.modified = true;
        }
    }

    boolean rowRemoved(int n, int n2) {
        int n3;
        if (n != this.sheetRef) {
            return false;
        }
        for (n3 = 0; n3 < this.ranges.length; ++n3) {
            if (n2 == this.ranges[n3].getFirstRow() && n2 == this.ranges[n3].getLastRow()) {
                this.ranges[n3] = EMPTY_RANGE;
            }
            if (n2 < this.ranges[n3].getFirstRow() && n2 > 0) {
                this.ranges[n3].decrementFirstRow();
                this.modified = true;
            }
            if (n2 > this.ranges[n3].getLastRow()) continue;
            this.ranges[n3].decrementLastRow();
            this.modified = true;
        }
        n3 = 0;
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i] != EMPTY_RANGE) continue;
            ++n3;
        }
        if (n3 == this.ranges.length) {
            return true;
        }
        NameRange[] nameRangeArray = new NameRange[this.ranges.length - n3];
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i] == EMPTY_RANGE) continue;
            nameRangeArray[i] = this.ranges[i];
        }
        this.ranges = nameRangeArray;
        return false;
    }

    boolean columnRemoved(int n, int n2) {
        int n3;
        if (n != this.sheetRef) {
            return false;
        }
        for (n3 = 0; n3 < this.ranges.length; ++n3) {
            if (n2 == this.ranges[n3].getFirstColumn() && n2 == this.ranges[n3].getLastColumn()) {
                this.ranges[n3] = EMPTY_RANGE;
            }
            if (n2 < this.ranges[n3].getFirstColumn() && n2 > 0) {
                this.ranges[n3].decrementFirstColumn();
                this.modified = true;
            }
            if (n2 > this.ranges[n3].getLastColumn()) continue;
            this.ranges[n3].decrementLastColumn();
            this.modified = true;
        }
        n3 = 0;
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i] != EMPTY_RANGE) continue;
            ++n3;
        }
        if (n3 == this.ranges.length) {
            return true;
        }
        NameRange[] nameRangeArray = new NameRange[this.ranges.length - n3];
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i] == EMPTY_RANGE) continue;
            nameRangeArray[i] = this.ranges[i];
        }
        this.ranges = nameRangeArray;
        return false;
    }

    void columnInserted(int n, int n2) {
        if (n != this.sheetRef) {
            return;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            if (n2 <= this.ranges[i].getFirstColumn()) {
                this.ranges[i].incrementFirstColumn();
                this.modified = true;
            }
            if (n2 > this.ranges[i].getLastColumn()) continue;
            this.ranges[i].incrementLastColumn();
            this.modified = true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class NameRange {
        private int columnFirst;
        private int rowFirst;
        private int columnLast;
        private int rowLast;
        private int externalSheet;

        NameRange(NameRecord.NameRange nameRange) {
            this.columnFirst = nameRange.getFirstColumn();
            this.rowFirst = nameRange.getFirstRow();
            this.columnLast = nameRange.getLastColumn();
            this.rowLast = nameRange.getLastRow();
            this.externalSheet = nameRange.getExternalSheet();
        }

        NameRange(int n, int n2, int n3, int n4, int n5) {
            this.columnFirst = n4;
            this.rowFirst = n2;
            this.columnLast = n5;
            this.rowLast = n3;
            this.externalSheet = n;
        }

        int getFirstColumn() {
            return this.columnFirst;
        }

        int getFirstRow() {
            return this.rowFirst;
        }

        int getLastColumn() {
            return this.columnLast;
        }

        int getLastRow() {
            return this.rowLast;
        }

        int getExternalSheet() {
            return this.externalSheet;
        }

        void incrementFirstRow() {
            ++this.rowFirst;
        }

        void incrementLastRow() {
            ++this.rowLast;
        }

        void decrementFirstRow() {
            --this.rowFirst;
        }

        void decrementLastRow() {
            --this.rowLast;
        }

        void incrementFirstColumn() {
            ++this.columnFirst;
        }

        void incrementLastColumn() {
            ++this.columnLast;
        }

        void decrementFirstColumn() {
            --this.columnFirst;
        }

        void decrementLastColumn() {
            --this.columnLast;
        }

        byte[] getData() {
            byte[] byArray = new byte[10];
            IntegerHelper.getTwoBytes(this.externalSheet, byArray, 0);
            IntegerHelper.getTwoBytes(this.rowFirst, byArray, 2);
            IntegerHelper.getTwoBytes(this.rowLast, byArray, 4);
            IntegerHelper.getTwoBytes(this.columnFirst & 0xFF, byArray, 6);
            IntegerHelper.getTwoBytes(this.columnLast & 0xFF, byArray, 8);
            return byArray;
        }
    }
}

