/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import jxl.CellType;
import jxl.LabelCell;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.format.CellFormat;
import jxl.write.biff.CellValue;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.WritableSheetImpl;

public abstract class LabelRecord
extends CellValue {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$LabelRecord == null ? (class$jxl$write$biff$LabelRecord = LabelRecord.class$("jxl.write.biff.LabelRecord")) : class$jxl$write$biff$LabelRecord);
    private String contents;
    private SharedStrings sharedStrings;
    private int index;
    static /* synthetic */ Class class$jxl$write$biff$LabelRecord;

    protected LabelRecord(int n, int n2, String string) {
        super(Type.LABELSST, n, n2);
        this.contents = string;
        if (this.contents == null) {
            this.contents = "";
        }
    }

    protected LabelRecord(int n, int n2, String string, CellFormat cellFormat) {
        super(Type.LABELSST, n, n2, cellFormat);
        this.contents = string;
        if (this.contents == null) {
            this.contents = "";
        }
    }

    protected LabelRecord(int n, int n2, LabelRecord labelRecord) {
        super(Type.LABELSST, n, n2, labelRecord);
        this.contents = labelRecord.contents;
    }

    protected LabelRecord(LabelCell labelCell) {
        super(Type.LABELSST, labelCell);
        this.contents = labelCell.getString();
        if (this.contents == null) {
            this.contents = "";
        }
    }

    public CellType getType() {
        return CellType.LABEL;
    }

    public byte[] getData() {
        byte[] byArray = super.getData();
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        IntegerHelper.getFourBytes(this.index, byArray2, byArray.length);
        return byArray2;
    }

    public String getContents() {
        return this.contents;
    }

    public String getString() {
        return this.contents;
    }

    protected void setString(String string) {
        if (string == null) {
            string = "";
        }
        this.contents = string;
        if (!this.isReferenced()) {
            return;
        }
        Assert.verify(this.sharedStrings != null);
        this.index = this.sharedStrings.getIndex(this.contents);
        this.contents = this.sharedStrings.get(this.index);
    }

    void setCellDetails(FormattingRecords formattingRecords, SharedStrings sharedStrings, WritableSheetImpl writableSheetImpl) {
        super.setCellDetails(formattingRecords, sharedStrings, writableSheetImpl);
        this.sharedStrings = sharedStrings;
        this.index = this.sharedStrings.getIndex(this.contents);
        this.contents = this.sharedStrings.get(this.index);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

