/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.Sheet;
import jxl.WorkbookSettings;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.format.CellFormat;
import jxl.write.WritableCell;
import jxl.write.biff.CellValue;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.WritableSheetImpl;

public class FormulaRecord
extends CellValue
implements FormulaData {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$FormulaRecord == null ? (class$jxl$write$biff$FormulaRecord = FormulaRecord.class$("jxl.write.biff.FormulaRecord")) : class$jxl$write$biff$FormulaRecord);
    private String formulaToParse;
    private FormulaParser parser;
    private String formulaString;
    private byte[] formulaBytes;
    private CellValue copiedFrom;
    static /* synthetic */ Class class$jxl$write$biff$FormulaRecord;

    public FormulaRecord(int n, int n2, String string) {
        super(Type.FORMULA2, n, n2);
        this.formulaToParse = string;
        this.copiedFrom = null;
    }

    public FormulaRecord(int n, int n2, String string, CellFormat cellFormat) {
        super(Type.FORMULA, n, n2, cellFormat);
        this.formulaToParse = string;
        this.copiedFrom = null;
    }

    protected FormulaRecord(int n, int n2, FormulaRecord formulaRecord) {
        super(Type.FORMULA, n, n2, formulaRecord);
        this.copiedFrom = formulaRecord;
        this.formulaBytes = new byte[formulaRecord.formulaBytes.length];
        System.arraycopy(formulaRecord.formulaBytes, 0, this.formulaBytes, 0, this.formulaBytes.length);
    }

    protected FormulaRecord(int n, int n2, ReadFormulaRecord readFormulaRecord) {
        super(Type.FORMULA, n, n2, readFormulaRecord);
        try {
            this.copiedFrom = readFormulaRecord;
            this.formulaBytes = readFormulaRecord.getFormulaBytes();
        }
        catch (FormulaException formulaException) {
            logger.error("", formulaException);
        }
    }

    private void initialize(WorkbookSettings workbookSettings, ExternalSheet externalSheet, WorkbookMethods workbookMethods) {
        if (this.copiedFrom != null) {
            this.initializeCopiedFormula(workbookSettings, externalSheet, workbookMethods);
            return;
        }
        this.parser = new FormulaParser(this.formulaToParse, externalSheet, workbookMethods, workbookSettings);
        try {
            this.parser.parse();
            this.formulaString = this.parser.getFormula();
            this.formulaBytes = this.parser.getBytes();
        }
        catch (FormulaException formulaException) {
            logger.warn(formulaException.getMessage() + " when parsing formula " + this.formulaToParse + " in cell " + this.getSheet().getName() + "!" + CellReferenceHelper.getCellReference(this.getColumn(), this.getRow()));
            try {
                this.formulaToParse = "ERROR(1)";
                this.parser = new FormulaParser(this.formulaToParse, externalSheet, workbookMethods, workbookSettings);
                this.parser.parse();
                this.formulaString = this.parser.getFormula();
                this.formulaBytes = this.parser.getBytes();
            }
            catch (FormulaException formulaException2) {
                logger.error("", formulaException2);
            }
        }
    }

    private void initializeCopiedFormula(WorkbookSettings workbookSettings, ExternalSheet externalSheet, WorkbookMethods workbookMethods) {
        try {
            this.parser = new FormulaParser(this.formulaBytes, this, externalSheet, workbookMethods, workbookSettings);
            this.parser.parse();
            this.parser.adjustRelativeCellReferences(this.getColumn() - this.copiedFrom.getColumn(), this.getRow() - this.copiedFrom.getRow());
            this.formulaString = this.parser.getFormula();
            this.formulaBytes = this.parser.getBytes();
        }
        catch (FormulaException formulaException) {
            try {
                this.formulaToParse = "ERROR(1)";
                this.parser = new FormulaParser(this.formulaToParse, externalSheet, workbookMethods, workbookSettings);
                this.parser.parse();
                this.formulaString = this.parser.getFormula();
                this.formulaBytes = this.parser.getBytes();
            }
            catch (FormulaException formulaException2) {
                logger.error("", formulaException2);
            }
        }
    }

    void setCellDetails(FormattingRecords formattingRecords, SharedStrings sharedStrings, WritableSheetImpl writableSheetImpl) {
        super.setCellDetails(formattingRecords, sharedStrings, writableSheetImpl);
        this.initialize(writableSheetImpl.getWorkbookSettings(), writableSheetImpl.getWorkbook(), writableSheetImpl.getWorkbook());
        writableSheetImpl.getWorkbook().addRCIRCell(this);
    }

    public byte[] getData() {
        byte[] byArray = super.getData();
        byte[] byArray2 = this.getFormulaData();
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public CellType getType() {
        return CellType.ERROR;
    }

    public String getContents() {
        return this.formulaString;
    }

    public byte[] getFormulaData() {
        byte[] byArray = new byte[this.formulaBytes.length + 16];
        System.arraycopy(this.formulaBytes, 0, byArray, 16, this.formulaBytes.length);
        byArray[6] = 16;
        byArray[7] = 64;
        byArray[12] = -32;
        byArray[13] = -4;
        byArray[8] = (byte)(byArray[8] | 2);
        IntegerHelper.getTwoBytes(this.formulaBytes.length, byArray, 14);
        return byArray;
    }

    public WritableCell copyTo(int n, int n2) {
        Assert.verify(false);
        return null;
    }

    void columnInserted(Sheet sheet, int n, int n2) {
        this.parser.columnInserted(n, n2, sheet == this.getSheet());
        this.formulaBytes = this.parser.getBytes();
    }

    void columnRemoved(Sheet sheet, int n, int n2) {
        this.parser.columnRemoved(n, n2, sheet == this.getSheet());
        this.formulaBytes = this.parser.getBytes();
    }

    void rowInserted(Sheet sheet, int n, int n2) {
        this.parser.rowInserted(n, n2, sheet == this.getSheet());
        this.formulaBytes = this.parser.getBytes();
    }

    void rowRemoved(Sheet sheet, int n, int n2) {
        this.parser.rowRemoved(n, n2, sheet == this.getSheet());
        this.formulaBytes = this.parser.getBytes();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

