/*
 * Decompiled with CFR 0.152.
 */
package jxl.write;

import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.write.WriteException;
import jxl.write.biff.WritableFontRecord;

public class WritableFont
extends WritableFontRecord {
    public static final FontName ARIAL = new FontName("Arial");
    public static final FontName TIMES = new FontName("Times New Roman");
    public static final FontName COURIER = new FontName("Courier New");
    public static final FontName TAHOMA = new FontName("Tahoma");
    public static final BoldStyle NO_BOLD = new BoldStyle(400);
    public static final BoldStyle BOLD = new BoldStyle(700);
    public static final int DEFAULT_POINT_SIZE = 10;

    public WritableFont(FontName fontName) {
        this(fontName, 10, NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(Font font) {
        super(font);
    }

    public WritableFont(FontName fontName, int n) {
        this(fontName, n, NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fontName, int n, BoldStyle boldStyle) {
        this(fontName, n, boldStyle, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fontName, int n, BoldStyle boldStyle, boolean bl) {
        this(fontName, n, boldStyle, bl, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fontName, int n, BoldStyle boldStyle, boolean bl, UnderlineStyle underlineStyle) {
        this(fontName, n, boldStyle, bl, underlineStyle, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fontName, int n, BoldStyle boldStyle, boolean bl, UnderlineStyle underlineStyle, Colour colour) {
        this(fontName, n, boldStyle, bl, underlineStyle, colour, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fontName, int n, BoldStyle boldStyle, boolean bl, UnderlineStyle underlineStyle, Colour colour, ScriptStyle scriptStyle) {
        super(fontName.name, n, boldStyle.value, bl, underlineStyle.getValue(), colour.getValue(), scriptStyle.getValue());
    }

    public void setPointSize(int n) throws WriteException {
        super.setPointSize(n);
    }

    public void setBoldStyle(BoldStyle boldStyle) throws WriteException {
        super.setBoldStyle(boldStyle.value);
    }

    public void setItalic(boolean bl) throws WriteException {
        super.setItalic(bl);
    }

    public void setUnderlineStyle(UnderlineStyle underlineStyle) throws WriteException {
        super.setUnderlineStyle(underlineStyle.getValue());
    }

    public void setColour(Colour colour) throws WriteException {
        super.setColour(colour.getValue());
    }

    public void setScriptStyle(ScriptStyle scriptStyle) throws WriteException {
        super.setScriptStyle(scriptStyle.getValue());
    }

    public boolean isStruckout() {
        return super.isStruckout();
    }

    public void setStruckout(boolean bl) throws WriteException {
        super.setStruckout(bl);
    }

    public static FontName createFont(String string) {
        return new FontName(string);
    }

    static class BoldStyle {
        public int value;

        BoldStyle(int n) {
            this.value = n;
        }
    }

    public static class FontName {
        String name;

        FontName(String string) {
            this.name = string;
        }
    }
}

