/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import jxl.WorkbookSettings;
import jxl.biff.BuiltInName;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;

public class NameRecord
extends RecordData {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$NameRecord == null ? (class$jxl$read$biff$NameRecord = NameRecord.class$("jxl.read.biff.NameRecord")) : class$jxl$read$biff$NameRecord);
    private String name;
    private BuiltInName builtInName;
    private int index;
    private int sheetRef = 0;
    private boolean isbiff8;
    public static Biff7 biff7 = new Biff7();
    private static final int commandMacro = 12;
    private static final int builtIn = 32;
    private static final int cellReference = 58;
    private static final int areaReference = 59;
    private static final int subExpression = 41;
    private static final int union = 16;
    private ArrayList ranges;
    static /* synthetic */ Class class$jxl$read$biff$NameRecord;

    NameRecord(Record record, WorkbookSettings workbookSettings, int n) {
        super(record);
        this.index = n;
        this.isbiff8 = true;
        try {
            this.ranges = new ArrayList();
            byte[] byArray = this.getRecord().getData();
            int n2 = IntegerHelper.getInt(byArray[0], byArray[1]);
            byte by = byArray[3];
            this.sheetRef = IntegerHelper.getInt(byArray[8], byArray[9]);
            if ((n2 & 0x20) != 0) {
                this.builtInName = BuiltInName.getBuiltInName(byArray[15]);
            } else {
                this.name = StringHelper.getString(byArray, by, 15, workbookSettings);
            }
            if ((n2 & 0xC) != 0) {
                return;
            }
            int n3 = by + 15;
            if (byArray[n3] == 58) {
                int n4 = IntegerHelper.getInt(byArray[n3 + 1], byArray[n3 + 2]);
                int n5 = IntegerHelper.getInt(byArray[n3 + 3], byArray[n3 + 4]);
                int n6 = IntegerHelper.getInt(byArray[n3 + 5], byArray[n3 + 6]);
                int n7 = n6 & 0xFF;
                Assert.verify((n6 & 0xC0000) == 0);
                NameRange nameRange = new NameRange(n4, n7, n5, n7, n5);
                this.ranges.add(nameRange);
            } else if (byArray[n3] == 59) {
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                NameRange nameRange = null;
                while (n3 < byArray.length) {
                    n8 = IntegerHelper.getInt(byArray[n3 + 1], byArray[n3 + 2]);
                    n9 = IntegerHelper.getInt(byArray[n3 + 3], byArray[n3 + 4]);
                    n12 = IntegerHelper.getInt(byArray[n3 + 5], byArray[n3 + 6]);
                    n10 = IntegerHelper.getInt(byArray[n3 + 7], byArray[n3 + 8]);
                    n11 = n10 & 0xFF;
                    Assert.verify((n10 & 0xC0000) == 0);
                    n10 = IntegerHelper.getInt(byArray[n3 + 9], byArray[n3 + 10]);
                    n13 = n10 & 0xFF;
                    Assert.verify((n10 & 0xC0000) == 0);
                    nameRange = new NameRange(n8, n11, n9, n13, n12);
                    this.ranges.add(nameRange);
                    n3 += 11;
                }
            } else if (byArray[n3] == 41) {
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                NameRange nameRange = null;
                if (n3 < byArray.length && byArray[n3] != 58 && byArray[n3] != 59) {
                    if (byArray[n3] == 41) {
                        n3 += 3;
                    } else if (byArray[n3] == 16) {
                        ++n3;
                    }
                }
                while (n3 < byArray.length) {
                    n14 = IntegerHelper.getInt(byArray[n3 + 1], byArray[n3 + 2]);
                    n15 = IntegerHelper.getInt(byArray[n3 + 3], byArray[n3 + 4]);
                    n18 = IntegerHelper.getInt(byArray[n3 + 5], byArray[n3 + 6]);
                    n16 = IntegerHelper.getInt(byArray[n3 + 7], byArray[n3 + 8]);
                    n17 = n16 & 0xFF;
                    Assert.verify((n16 & 0xC0000) == 0);
                    n16 = IntegerHelper.getInt(byArray[n3 + 9], byArray[n3 + 10]);
                    n19 = n16 & 0xFF;
                    Assert.verify((n16 & 0xC0000) == 0);
                    nameRange = new NameRange(n14, n17, n15, n19, n18);
                    this.ranges.add(nameRange);
                    if ((n3 += 11) >= byArray.length || byArray[n3] == 58 || byArray[n3] == 59) continue;
                    if (byArray[n3] == 41) {
                        n3 += 3;
                        continue;
                    }
                    if (byArray[n3] != 16) continue;
                    ++n3;
                }
            } else {
                String string = this.name != null ? this.name : this.builtInName.getName();
                logger.warn("Cannot read name ranges for " + string + " - setting to empty");
                NameRange nameRange = new NameRange(0, 0, 0, 0, 0);
                this.ranges.add(nameRange);
            }
        }
        catch (Throwable throwable) {
            logger.warn("Cannot read name");
            this.name = "ERROR";
        }
    }

    NameRecord(Record record, WorkbookSettings workbookSettings, int n, Biff7 biff7) {
        super(record);
        this.index = n;
        this.isbiff8 = false;
        try {
            int n2;
            this.ranges = new ArrayList();
            byte[] byArray = this.getRecord().getData();
            byte by = byArray[3];
            this.sheetRef = IntegerHelper.getInt(byArray[8], byArray[9]);
            this.name = StringHelper.getString(byArray, by, 14, workbookSettings);
            if (n2 >= byArray.length) {
                return;
            }
            if (byArray[n2] == 58) {
                int n3 = IntegerHelper.getInt(byArray[n2 + 11], byArray[n2 + 12]);
                int n4 = IntegerHelper.getInt(byArray[n2 + 15], byArray[n2 + 16]);
                byte by2 = byArray[n2 + 17];
                NameRange nameRange = new NameRange(n3, by2, n4, by2, n4);
                this.ranges.add(nameRange);
            } else if (byArray[n2] == 59) {
                int n5 = 0;
                int n6 = 0;
                byte by3 = 0;
                int n7 = 0;
                byte by4 = 0;
                NameRange nameRange = null;
                for (n2 = by + 14; n2 < byArray.length; n2 += 21) {
                    n5 = IntegerHelper.getInt(byArray[n2 + 11], byArray[n2 + 12]);
                    n6 = IntegerHelper.getInt(byArray[n2 + 15], byArray[n2 + 16]);
                    n7 = IntegerHelper.getInt(byArray[n2 + 17], byArray[n2 + 18]);
                    by3 = byArray[n2 + 19];
                    by4 = byArray[n2 + 20];
                    nameRange = new NameRange(n5, by3, n6, by4, n7);
                    this.ranges.add(nameRange);
                }
            } else if (byArray[n2] == 41) {
                int n8 = 0;
                boolean bl = false;
                int n9 = 0;
                byte by5 = 0;
                int n10 = 0;
                byte by6 = 0;
                NameRange nameRange = null;
                if (n2 < byArray.length && byArray[n2] != 58 && byArray[n2] != 59) {
                    if (byArray[n2] == 41) {
                        n2 += 3;
                    } else if (byArray[n2] == 16) {
                        ++n2;
                    }
                }
                while (n2 < byArray.length) {
                    n8 = IntegerHelper.getInt(byArray[n2 + 11], byArray[n2 + 12]);
                    n9 = IntegerHelper.getInt(byArray[n2 + 15], byArray[n2 + 16]);
                    n10 = IntegerHelper.getInt(byArray[n2 + 17], byArray[n2 + 18]);
                    by5 = byArray[n2 + 19];
                    by6 = byArray[n2 + 20];
                    nameRange = new NameRange(n8, by5, n9, by6, n10);
                    this.ranges.add(nameRange);
                    if ((n2 += 21) >= byArray.length || byArray[n2] == 58 || byArray[n2] == 59) continue;
                    if (byArray[n2] == 41) {
                        n2 += 3;
                        continue;
                    }
                    if (byArray[n2] != 16) continue;
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            logger.warn("Cannot read name.");
            this.name = "ERROR";
        }
    }

    public String getName() {
        return this.name;
    }

    public BuiltInName getBuiltInName() {
        return this.builtInName;
    }

    public NameRange[] getRanges() {
        NameRange[] nameRangeArray = new NameRange[this.ranges.size()];
        return this.ranges.toArray(nameRangeArray);
    }

    int getIndex() {
        return this.index;
    }

    public int getSheetRef() {
        return this.sheetRef;
    }

    public void setSheetRef(int n) {
        this.sheetRef = n;
    }

    public byte[] getData() {
        return this.getRecord().getData();
    }

    public boolean isBiff8() {
        return this.isbiff8;
    }

    public boolean isGlobal() {
        return this.sheetRef == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class NameRange {
        private int columnFirst;
        private int rowFirst;
        private int columnLast;
        private int rowLast;
        private int externalSheet;

        NameRange(int n, int n2, int n3, int n4, int n5) {
            this.columnFirst = n2;
            this.rowFirst = n3;
            this.columnLast = n4;
            this.rowLast = n5;
            this.externalSheet = n;
        }

        public int getFirstColumn() {
            return this.columnFirst;
        }

        public int getFirstRow() {
            return this.rowFirst;
        }

        public int getLastColumn() {
            return this.columnLast;
        }

        public int getLastRow() {
            return this.rowLast;
        }

        public int getExternalSheet() {
            return this.externalSheet;
        }
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

