/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.CellType;
import jxl.LabelCell;
import jxl.WorkbookSettings;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.read.biff.CellValue;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

class LabelRecord
extends CellValue
implements LabelCell {
    private int length;
    private String string;
    public static Biff7 biff7 = new Biff7();

    public LabelRecord(Record record, FormattingRecords formattingRecords, SheetImpl sheetImpl, WorkbookSettings workbookSettings) {
        super(record, formattingRecords, sheetImpl);
        byte[] byArray = this.getRecord().getData();
        this.length = IntegerHelper.getInt(byArray[6], byArray[7]);
        this.string = byArray[8] == 0 ? StringHelper.getString(byArray, this.length, 9, workbookSettings) : StringHelper.getUnicodeString(byArray, this.length, 9);
    }

    public LabelRecord(Record record, FormattingRecords formattingRecords, SheetImpl sheetImpl, WorkbookSettings workbookSettings, Biff7 biff7) {
        super(record, formattingRecords, sheetImpl);
        byte[] byArray = this.getRecord().getData();
        this.length = IntegerHelper.getInt(byArray[6], byArray[7]);
        this.string = StringHelper.getString(byArray, this.length, 8, workbookSettings);
    }

    public String getString() {
        return this.string;
    }

    public String getContents() {
        return this.string;
    }

    public CellType getType() {
        return CellType.LABEL;
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

