/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.Pattern;

public class XML {
    private OutputStream out;
    private String encoding;
    private Workbook workbook;

    public XML(Workbook workbook, OutputStream outputStream, String string, boolean bl) throws IOException {
        this.encoding = string;
        this.workbook = workbook;
        this.out = outputStream;
        if (this.encoding == null || !this.encoding.equals("UnicodeBig")) {
            this.encoding = "UTF8";
        }
        if (bl) {
            this.writeFormattedXML();
        } else {
            this.writeXML();
        }
    }

    private void writeXML() throws IOException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.out, this.encoding);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>");
            bufferedWriter.newLine();
            bufferedWriter.write("<!DOCTYPE workbook SYSTEM \"workbook.dtd\">");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("<workbook>");
            bufferedWriter.newLine();
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = this.workbook.getSheet(i);
                bufferedWriter.write("  <sheet>");
                bufferedWriter.newLine();
                bufferedWriter.write("    <name><![CDATA[" + sheet.getName() + "]]></name>");
                bufferedWriter.newLine();
                Cell[] cellArray = null;
                for (int j = 0; j < sheet.getRows(); ++j) {
                    bufferedWriter.write("    <row number=\"" + j + "\">");
                    bufferedWriter.newLine();
                    cellArray = sheet.getRow(j);
                    for (int k = 0; k < cellArray.length; ++k) {
                        if (cellArray[k].getType() == CellType.EMPTY) continue;
                        bufferedWriter.write("      <col number=\"" + k + "\">");
                        bufferedWriter.write("<![CDATA[" + cellArray[k].getContents() + "]]>");
                        bufferedWriter.write("</col>");
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.write("    </row>");
                    bufferedWriter.newLine();
                }
                bufferedWriter.write("  </sheet>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("</workbook>");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.toString());
        }
    }

    private void writeFormattedXML() throws IOException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.out, this.encoding);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>");
            bufferedWriter.newLine();
            bufferedWriter.write("<!DOCTYPE workbook SYSTEM \"formatworkbook.dtd\">");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("<workbook>");
            bufferedWriter.newLine();
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = this.workbook.getSheet(i);
                bufferedWriter.write("  <sheet>");
                bufferedWriter.newLine();
                bufferedWriter.write("    <name><![CDATA[" + sheet.getName() + "]]></name>");
                bufferedWriter.newLine();
                Cell[] cellArray = null;
                CellFormat cellFormat = null;
                Font font = null;
                for (int j = 0; j < sheet.getRows(); ++j) {
                    bufferedWriter.write("    <row number=\"" + j + "\">");
                    bufferedWriter.newLine();
                    cellArray = sheet.getRow(j);
                    for (int k = 0; k < cellArray.length; ++k) {
                        if (cellArray[k].getType() == CellType.EMPTY && cellArray[k].getCellFormat() == null) continue;
                        cellFormat = cellArray[k].getCellFormat();
                        bufferedWriter.write("      <col number=\"" + k + "\">");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        <data>");
                        bufferedWriter.write("<![CDATA[" + cellArray[k].getContents() + "]]>");
                        bufferedWriter.write("</data>");
                        bufferedWriter.newLine();
                        if (cellArray[k].getCellFormat() != null) {
                            bufferedWriter.write("        <format wrap=\"" + cellFormat.getWrap() + "\"");
                            bufferedWriter.newLine();
                            bufferedWriter.write("                align=\"" + cellFormat.getAlignment().getDescription() + "\"");
                            bufferedWriter.newLine();
                            bufferedWriter.write("                valign=\"" + cellFormat.getVerticalAlignment().getDescription() + "\"");
                            bufferedWriter.newLine();
                            bufferedWriter.write("                orientation=\"" + cellFormat.getOrientation().getDescription() + "\"");
                            bufferedWriter.write(">");
                            bufferedWriter.newLine();
                            font = cellFormat.getFont();
                            bufferedWriter.write("          <font name=\"" + font.getName() + "\"");
                            bufferedWriter.newLine();
                            bufferedWriter.write("                point_size=\"" + font.getPointSize() + "\"");
                            bufferedWriter.newLine();
                            bufferedWriter.write("                bold_weight=\"" + font.getBoldWeight() + "\"");
                            bufferedWriter.newLine();
                            bufferedWriter.write("                italic=\"" + font.isItalic() + "\"");
                            bufferedWriter.newLine();
                            bufferedWriter.write("                underline=\"" + font.getUnderlineStyle().getDescription() + "\"");
                            bufferedWriter.newLine();
                            bufferedWriter.write("                colour=\"" + font.getColour().getDescription() + "\"");
                            bufferedWriter.newLine();
                            bufferedWriter.write("                script=\"" + font.getScriptStyle().getDescription() + "\"");
                            bufferedWriter.write(" />");
                            bufferedWriter.newLine();
                            if (cellFormat.getBackgroundColour() != Colour.DEFAULT_BACKGROUND || cellFormat.getPattern() != Pattern.NONE) {
                                bufferedWriter.write("          <background colour=\"" + cellFormat.getBackgroundColour().getDescription() + "\"");
                                bufferedWriter.newLine();
                                bufferedWriter.write("                      pattern=\"" + cellFormat.getPattern().getDescription() + "\"");
                                bufferedWriter.write(" />");
                                bufferedWriter.newLine();
                            }
                            if (cellFormat.getBorder(Border.TOP) != BorderLineStyle.NONE || cellFormat.getBorder(Border.BOTTOM) != BorderLineStyle.NONE || cellFormat.getBorder(Border.LEFT) != BorderLineStyle.NONE || cellFormat.getBorder(Border.RIGHT) != BorderLineStyle.NONE) {
                                bufferedWriter.write("          <border top=\"" + cellFormat.getBorder(Border.TOP).getDescription() + "\"");
                                bufferedWriter.newLine();
                                bufferedWriter.write("                  bottom=\"" + cellFormat.getBorder(Border.BOTTOM).getDescription() + "\"");
                                bufferedWriter.newLine();
                                bufferedWriter.write("                  left=\"" + cellFormat.getBorder(Border.LEFT).getDescription() + "\"");
                                bufferedWriter.newLine();
                                bufferedWriter.write("                  right=\"" + cellFormat.getBorder(Border.RIGHT).getDescription() + "\"");
                                bufferedWriter.write(" />");
                                bufferedWriter.newLine();
                            }
                            if (!cellFormat.getFormat().getFormatString().equals("")) {
                                bufferedWriter.write("          <format_string string=\"");
                                bufferedWriter.write(cellFormat.getFormat().getFormatString());
                                bufferedWriter.write("\" />");
                                bufferedWriter.newLine();
                            }
                            bufferedWriter.write("        </format>");
                            bufferedWriter.newLine();
                        }
                        bufferedWriter.write("      </col>");
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.write("    </row>");
                    bufferedWriter.newLine();
                }
                bufferedWriter.write("  </sheet>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("</workbook>");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.toString());
        }
    }
}

