/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import jxl.WorkbookSettings;
import jxl.biff.BaseCompoundFile;
import jxl.read.biff.BiffException;
import jxl.read.biff.CompoundFile;

class PropertySetsReader {
    private BufferedWriter writer;
    private CompoundFile compoundFile;

    public PropertySetsReader(File file, String string, OutputStream outputStream) throws IOException, BiffException {
        int n;
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        FileInputStream fileInputStream = new FileInputStream(file);
        int n2 = 0x100000;
        int n3 = 0x100000;
        byte[] byArray = new byte[n2];
        int n4 = n = fileInputStream.read(byArray);
        while (n != -1) {
            if (n4 >= byArray.length) {
                byte[] byArray2 = new byte[byArray.length + n3];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            n = fileInputStream.read(byArray, n4, byArray.length - n4);
            n4 += n;
        }
        n = n4 + 1;
        this.compoundFile = new CompoundFile(byArray, new WorkbookSettings());
        fileInputStream.close();
        if (string == null) {
            this.displaySets();
        } else {
            this.displayPropertySet(string, outputStream);
        }
    }

    void displaySets() throws IOException {
        int n = this.compoundFile.getNumberOfPropertySets();
        for (int i = 0; i < n; ++i) {
            BaseCompoundFile.PropertyStorage propertyStorage = this.compoundFile.getPropertySet(i);
            this.writer.write(Integer.toString(i));
            this.writer.write(") ");
            this.writer.write(propertyStorage.name);
            this.writer.write("(type ");
            this.writer.write(Integer.toString(propertyStorage.type));
            this.writer.write(" size ");
            this.writer.write(Integer.toString(propertyStorage.size));
            this.writer.write(" prev ");
            this.writer.write(Integer.toString(propertyStorage.previous));
            this.writer.write(" next ");
            this.writer.write(Integer.toString(propertyStorage.next));
            this.writer.write(" child ");
            this.writer.write(Integer.toString(propertyStorage.child));
            this.writer.write(" start block ");
            this.writer.write(Integer.toString(propertyStorage.startBlock));
            this.writer.write(")");
            this.writer.newLine();
        }
        this.writer.flush();
        this.writer.close();
    }

    void displayPropertySet(String string, OutputStream outputStream) throws IOException, BiffException {
        if (string.equalsIgnoreCase("SummaryInformation")) {
            string = "\u0005SummaryInformation";
        } else if (string.equalsIgnoreCase("DocumentSummaryInformation")) {
            string = "\u0005DocumentSummaryInformation";
        } else if (string.equalsIgnoreCase("CompObj")) {
            string = "\u0001CompObj";
        }
        byte[] byArray = this.compoundFile.getStream(string);
        outputStream.write(byArray);
    }
}

