/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.FormulaCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.biff.CellReferenceHelper;
import jxl.biff.formula.FormulaException;

public class Formulas {
    public Formulas(Workbook workbook, OutputStream outputStream, String string) throws IOException {
        if (string == null || !string.equals("UnicodeBig")) {
            string = "UTF8";
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = workbook.getSheet(i);
                bufferedWriter.write(sheet.getName());
                bufferedWriter.newLine();
                Cell[] cellArray = null;
                Cell cell = null;
                for (int j = 0; j < sheet.getRows(); ++j) {
                    cellArray = sheet.getRow(j);
                    for (int k = 0; k < cellArray.length; ++k) {
                        cell = cellArray[k];
                        if (cell.getType() != CellType.NUMBER_FORMULA && cell.getType() != CellType.STRING_FORMULA && cell.getType() != CellType.BOOLEAN_FORMULA && cell.getType() != CellType.DATE_FORMULA && cell.getType() != CellType.FORMULA_ERROR) continue;
                        FormulaCell formulaCell = (FormulaCell)cell;
                        StringBuffer stringBuffer = new StringBuffer();
                        CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow(), stringBuffer);
                        try {
                            bufferedWriter.write("Formula in " + stringBuffer.toString() + " value:  " + cell.getContents());
                            bufferedWriter.flush();
                            bufferedWriter.write(" formula: " + formulaCell.getFormula());
                            bufferedWriter.flush();
                            bufferedWriter.newLine();
                            continue;
                        }
                        catch (FormulaException formulaException) {
                            bufferedWriter.newLine();
                            arrayList.add(sheet.getName() + '!' + stringBuffer.toString() + ": " + formulaException.getMessage());
                        }
                    }
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            if (arrayList.size() > 0) {
                System.err.println();
                System.err.println("There were " + arrayList.size() + " errors");
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    System.err.println(iterator.next());
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.toString());
        }
    }
}

