/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellReferenceHelper;
import jxl.Sheet;
import jxl.Workbook;

public class Features {
    public Features(Workbook workbook, OutputStream outputStream, String string) throws IOException {
        if (string == null || !string.equals("UnicodeBig")) {
            string = "UTF8";
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = workbook.getSheet(i);
                bufferedWriter.write(sheet.getName());
                bufferedWriter.newLine();
                Cell[] cellArray = null;
                Cell cell = null;
                for (int j = 0; j < sheet.getRows(); ++j) {
                    cellArray = sheet.getRow(j);
                    for (int k = 0; k < cellArray.length; ++k) {
                        cell = cellArray[k];
                        if (cell.getCellFeatures() == null) continue;
                        CellFeatures cellFeatures = cell.getCellFeatures();
                        StringBuffer stringBuffer = new StringBuffer();
                        CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow(), stringBuffer);
                        bufferedWriter.write("Cell " + stringBuffer.toString() + " contents:  " + cell.getContents());
                        bufferedWriter.flush();
                        bufferedWriter.write(" comment: " + cellFeatures.getComment());
                        bufferedWriter.flush();
                        bufferedWriter.newLine();
                    }
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.toString());
        }
    }
}

