/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Logger;
import jxl.Cell;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class CellReference3d
extends Operand
implements ParsedThing {
    private static Logger logger = Logger.getLogger(class$jxl$biff$formula$CellReference3d == null ? (class$jxl$biff$formula$CellReference3d = CellReference3d.class$("jxl.biff.formula.CellReference3d")) : class$jxl$biff$formula$CellReference3d);
    private boolean columnRelative;
    private boolean rowRelative;
    private int column;
    private int row;
    private Cell relativeTo;
    private int sheet;
    private ExternalSheet workbook;
    static /* synthetic */ Class class$jxl$biff$formula$CellReference3d;

    public CellReference3d(Cell cell, ExternalSheet externalSheet) {
        this.relativeTo = cell;
        this.workbook = externalSheet;
    }

    public CellReference3d(String string, ExternalSheet externalSheet) throws FormulaException {
        this.workbook = externalSheet;
        this.columnRelative = true;
        this.rowRelative = true;
        int n = string.indexOf(33);
        String string2 = string.substring(n + 1);
        this.column = CellReferenceHelper.getColumn(string2);
        this.row = CellReferenceHelper.getRow(string2);
        String string3 = string.substring(0, n);
        if (string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'') {
            string3 = string3.substring(1, string3.length() - 1);
        }
        this.sheet = externalSheet.getExternalSheetIndex(string3);
        if (this.sheet < 0) {
            throw new FormulaException(FormulaException.SHEET_REF_NOT_FOUND, string3);
        }
    }

    public int read(byte[] byArray, int n) {
        this.sheet = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        this.row = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3]);
        int n2 = IntegerHelper.getInt(byArray[n + 4], byArray[n + 5]);
        this.column = n2 & 0xFF;
        this.columnRelative = (n2 & 0x4000) != 0;
        this.rowRelative = (n2 & 0x8000) != 0;
        return 6;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public void getString(StringBuffer stringBuffer) {
        CellReferenceHelper.getCellReference(this.sheet, this.column, !this.columnRelative, this.row, !this.rowRelative, this.workbook, stringBuffer);
    }

    byte[] getBytes() {
        byte[] byArray = new byte[7];
        byArray[0] = Token.REF3D.getCode();
        IntegerHelper.getTwoBytes(this.sheet, byArray, 1);
        IntegerHelper.getTwoBytes(this.row, byArray, 3);
        int n = this.column;
        if (this.rowRelative) {
            n |= 0x8000;
        }
        if (this.columnRelative) {
            n |= 0x4000;
        }
        IntegerHelper.getTwoBytes(n, byArray, 5);
        return byArray;
    }

    public void adjustRelativeCellReferences(int n, int n2) {
        if (this.columnRelative) {
            this.column += n;
        }
        if (this.rowRelative) {
            this.row += n2;
        }
    }

    public void columnInserted(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.column >= n2) {
            ++this.column;
        }
    }

    void columnRemoved(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.column >= n2) {
            --this.column;
        }
    }

    void rowInserted(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.row >= n2) {
            ++this.row;
        }
    }

    void rowRemoved(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.row >= n2) {
            --this.row;
        }
    }

    void handleImportedCellReferences() {
        this.setInvalid();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

