/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import common.Logger;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class Area
extends Operand
implements ParsedThing {
    private static Logger logger = Logger.getLogger(class$jxl$biff$formula$Area == null ? (class$jxl$biff$formula$Area = Area.class$("jxl.biff.formula.Area")) : class$jxl$biff$formula$Area);
    private int columnFirst;
    private int rowFirst;
    private int columnLast;
    private int rowLast;
    private boolean columnFirstRelative;
    private boolean rowFirstRelative;
    private boolean columnLastRelative;
    private boolean rowLastRelative;
    static /* synthetic */ Class class$jxl$biff$formula$Area;

    Area() {
    }

    Area(String string) {
        int n = string.indexOf(":");
        Assert.verify(n != -1);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        this.columnFirst = CellReferenceHelper.getColumn(string2);
        this.rowFirst = CellReferenceHelper.getRow(string2);
        this.columnLast = CellReferenceHelper.getColumn(string3);
        this.rowLast = CellReferenceHelper.getRow(string3);
        this.columnFirstRelative = CellReferenceHelper.isColumnRelative(string2);
        this.rowFirstRelative = CellReferenceHelper.isRowRelative(string2);
        this.columnLastRelative = CellReferenceHelper.isColumnRelative(string3);
        this.rowLastRelative = CellReferenceHelper.isRowRelative(string3);
    }

    int getFirstColumn() {
        return this.columnFirst;
    }

    int getFirstRow() {
        return this.rowFirst;
    }

    int getLastColumn() {
        return this.columnLast;
    }

    int getLastRow() {
        return this.rowLast;
    }

    public int read(byte[] byArray, int n) {
        this.rowFirst = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        this.rowLast = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3]);
        int n2 = IntegerHelper.getInt(byArray[n + 4], byArray[n + 5]);
        this.columnFirst = n2 & 0xFF;
        this.columnFirstRelative = (n2 & 0x4000) != 0;
        this.rowFirstRelative = (n2 & 0x8000) != 0;
        n2 = IntegerHelper.getInt(byArray[n + 6], byArray[n + 7]);
        this.columnLast = n2 & 0xFF;
        this.columnLastRelative = (n2 & 0x4000) != 0;
        this.rowLastRelative = (n2 & 0x8000) != 0;
        return 8;
    }

    public void getString(StringBuffer stringBuffer) {
        CellReferenceHelper.getCellReference(this.columnFirst, this.rowFirst, stringBuffer);
        stringBuffer.append(':');
        CellReferenceHelper.getCellReference(this.columnLast, this.rowLast, stringBuffer);
    }

    byte[] getBytes() {
        byte[] byArray = new byte[9];
        byArray[0] = !this.useAlternateCode() ? Token.AREA.getCode() : Token.AREA.getCode2();
        IntegerHelper.getTwoBytes(this.rowFirst, byArray, 1);
        IntegerHelper.getTwoBytes(this.rowLast, byArray, 3);
        int n = this.columnFirst;
        if (this.rowFirstRelative) {
            n |= 0x8000;
        }
        if (this.columnFirstRelative) {
            n |= 0x4000;
        }
        IntegerHelper.getTwoBytes(n, byArray, 5);
        n = this.columnLast;
        if (this.rowLastRelative) {
            n |= 0x8000;
        }
        if (this.columnLastRelative) {
            n |= 0x4000;
        }
        IntegerHelper.getTwoBytes(n, byArray, 7);
        return byArray;
    }

    public void adjustRelativeCellReferences(int n, int n2) {
        if (this.columnFirstRelative) {
            this.columnFirst += n;
        }
        if (this.columnLastRelative) {
            this.columnLast += n;
        }
        if (this.rowFirstRelative) {
            this.rowFirst += n2;
        }
        if (this.rowLastRelative) {
            this.rowLast += n2;
        }
    }

    void columnInserted(int n, int n2, boolean bl) {
        if (!bl) {
            return;
        }
        if (n2 <= this.columnFirst) {
            ++this.columnFirst;
        }
        if (n2 <= this.columnLast) {
            ++this.columnLast;
        }
    }

    void columnRemoved(int n, int n2, boolean bl) {
        if (!bl) {
            return;
        }
        if (n2 < this.columnFirst) {
            --this.columnFirst;
        }
        if (n2 <= this.columnLast) {
            --this.columnLast;
        }
    }

    void rowInserted(int n, int n2, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.rowLast == 65535) {
            return;
        }
        if (n2 <= this.rowFirst) {
            ++this.rowFirst;
        }
        if (n2 <= this.rowLast) {
            ++this.rowLast;
        }
    }

    void rowRemoved(int n, int n2, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.rowLast == 65535) {
            return;
        }
        if (n2 < this.rowFirst) {
            --this.rowFirst;
        }
        if (n2 <= this.rowLast) {
            --this.rowLast;
        }
    }

    protected void setRangeData(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.columnFirst = n;
        this.columnLast = n2;
        this.rowFirst = n3;
        this.rowLast = n4;
        this.columnFirstRelative = bl;
        this.columnLastRelative = bl2;
        this.rowFirstRelative = bl3;
        this.rowLastRelative = bl4;
    }

    void handleImportedCellReferences() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

