/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;

final class EscherRecordData {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$EscherRecordData == null ? (class$jxl$biff$drawing$EscherRecordData = EscherRecordData.class$("jxl.biff.drawing.EscherRecordData")) : class$jxl$biff$drawing$EscherRecordData);
    private int pos;
    private int instance;
    private int version;
    private int recordId;
    private int length;
    private int streamLength;
    private boolean container;
    private EscherRecordType type;
    private EscherStream escherStream;
    static /* synthetic */ Class class$jxl$biff$drawing$EscherRecordData;

    public EscherRecordData(EscherStream escherStream, int n) {
        this.escherStream = escherStream;
        this.pos = n;
        byte[] byArray = this.escherStream.getData();
        this.streamLength = byArray.length;
        int n2 = IntegerHelper.getInt(byArray[this.pos], byArray[this.pos + 1]);
        this.instance = (n2 & 0xFFF0) >> 4;
        this.version = n2 & 0xF;
        this.recordId = IntegerHelper.getInt(byArray[this.pos + 2], byArray[this.pos + 3]);
        this.length = IntegerHelper.getInt(byArray[this.pos + 4], byArray[this.pos + 5], byArray[this.pos + 6], byArray[this.pos + 7]);
        this.container = this.version == 15;
    }

    public EscherRecordData(EscherRecordType escherRecordType) {
        this.type = escherRecordType;
        this.recordId = this.type.getValue();
    }

    public boolean isContainer() {
        return this.container;
    }

    public int getLength() {
        return this.length;
    }

    public int getRecordId() {
        return this.recordId;
    }

    EscherStream getDrawingGroup() {
        return this.escherStream;
    }

    int getPos() {
        return this.pos;
    }

    EscherRecordType getType() {
        if (this.type == null) {
            this.type = EscherRecordType.getType(this.recordId);
        }
        return this.type;
    }

    int getInstance() {
        return this.instance;
    }

    void setContainer(boolean bl) {
        this.container = bl;
    }

    void setInstance(int n) {
        this.instance = n;
    }

    void setLength(int n) {
        this.length = n;
    }

    void setVersion(int n) {
        this.version = n;
    }

    byte[] setHeaderData(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray2, 8, byArray.length);
        if (this.container) {
            this.version = 15;
        }
        int n = this.instance << 4;
        IntegerHelper.getTwoBytes(n |= this.version, byArray2, 0);
        IntegerHelper.getTwoBytes(this.recordId, byArray2, 2);
        IntegerHelper.getFourBytes(byArray.length, byArray2, 4);
        return byArray2;
    }

    EscherStream getEscherStream() {
        return this.escherStream;
    }

    byte[] getBytes() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.escherStream.getData(), this.pos + 8, byArray, 0, this.length);
        return byArray;
    }

    int getStreamLength() {
        return this.streamLength;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

