/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import java.io.BufferedWriter;
import java.io.IOException;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;

public class EscherDisplay {
    private EscherStream stream;
    private BufferedWriter writer;

    public EscherDisplay(EscherStream escherStream, BufferedWriter bufferedWriter) {
        this.stream = escherStream;
        this.writer = bufferedWriter;
    }

    public void display() throws IOException {
        EscherRecordData escherRecordData = new EscherRecordData(this.stream, 0);
        EscherContainer escherContainer = new EscherContainer(escherRecordData);
        this.displayContainer(escherContainer, 0);
    }

    private void displayContainer(EscherContainer escherContainer, int n) throws IOException {
        this.displayRecord(escherContainer, n);
        ++n;
        EscherRecord[] escherRecordArray = escherContainer.getChildren();
        for (int i = 0; i < escherRecordArray.length; ++i) {
            EscherRecord escherRecord = escherRecordArray[i];
            if (escherRecord.getEscherData().isContainer()) {
                this.displayContainer((EscherContainer)escherRecord, n);
                continue;
            }
            this.displayRecord(escherRecord, n);
        }
    }

    private void displayRecord(EscherRecord escherRecord, int n) throws IOException {
        this.indent(n);
        EscherRecordType escherRecordType = escherRecord.getType();
        this.writer.write(Integer.toString(escherRecordType.getValue(), 16));
        this.writer.write(" - ");
        if (escherRecordType == EscherRecordType.DGG_CONTAINER) {
            this.writer.write("Dgg Container");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.BSTORE_CONTAINER) {
            this.writer.write("BStore Container");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.DG_CONTAINER) {
            this.writer.write("Dg Container");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.SPGR_CONTAINER) {
            this.writer.write("Spgr Container");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.SP_CONTAINER) {
            this.writer.write("Sp Container");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.DGG) {
            this.writer.write("Dgg");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.BSE) {
            this.writer.write("Bse");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.DG) {
            this.writer.write("Dg");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.SPGR) {
            this.writer.write("Spgr");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.SP) {
            this.writer.write("Sp");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.OPT) {
            this.writer.write("Opt");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.CLIENT_ANCHOR) {
            this.writer.write("Client Anchor");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.CLIENT_DATA) {
            this.writer.write("Client Data");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.CLIENT_TEXT_BOX) {
            this.writer.write("Client Text Box");
            this.writer.newLine();
        } else if (escherRecordType == EscherRecordType.SPLIT_MENU_COLORS) {
            this.writer.write("Split Menu Colors");
            this.writer.newLine();
        } else {
            this.writer.write("???");
            this.writer.newLine();
        }
    }

    private void indent(int n) throws IOException {
        for (int i = 0; i < n * 2; ++i) {
            this.writer.write(32);
        }
    }
}

