/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.Origin;
import jxl.biff.drawing.ShapeType;

public class Drawing2
implements DrawingGroupObject {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$Drawing == null ? (class$jxl$biff$drawing$Drawing = Drawing2.class$("jxl.biff.drawing.Drawing")) : class$jxl$biff$drawing$Drawing);
    private EscherContainer readSpContainer;
    private MsoDrawingRecord msoDrawingRecord;
    private boolean initialized = false;
    private File imageFile;
    private byte[] imageData;
    private int objectId;
    private int blipId;
    private double x;
    private double y;
    private double width;
    private double height;
    private int referenceCount;
    private EscherContainer escherData;
    private Origin origin;
    private DrawingGroup drawingGroup;
    private DrawingData drawingData;
    private ShapeType type;
    private int shapeId;
    private int drawingNumber;
    static /* synthetic */ Class class$jxl$biff$drawing$Drawing;

    public Drawing2(MsoDrawingRecord msoDrawingRecord, DrawingData drawingData, DrawingGroup drawingGroup) {
        this.drawingGroup = drawingGroup;
        this.msoDrawingRecord = msoDrawingRecord;
        this.drawingData = drawingData;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData.addRawData(this.msoDrawingRecord.getData());
        this.drawingGroup.addDrawing(this);
        Assert.verify(msoDrawingRecord != null);
        this.initialize();
    }

    protected Drawing2(DrawingGroupObject drawingGroupObject, DrawingGroup drawingGroup) {
        Drawing2 drawing2 = (Drawing2)drawingGroupObject;
        Assert.verify(drawing2.origin == Origin.READ);
        this.msoDrawingRecord = drawing2.msoDrawingRecord;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData = drawing2.drawingData;
        this.drawingGroup = drawingGroup;
        this.drawingNumber = drawing2.drawingNumber;
        this.drawingGroup.addDrawing(this);
    }

    public Drawing2(double d, double d2, double d3, double d4, File file) {
        this.imageFile = file;
        this.initialized = true;
        this.origin = Origin.WRITE;
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.referenceCount = 1;
        this.type = ShapeType.PICTURE_FRAME;
    }

    public Drawing2(double d, double d2, double d3, double d4, byte[] byArray) {
        this.imageData = byArray;
        this.initialized = true;
        this.origin = Origin.WRITE;
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.referenceCount = 1;
        this.type = ShapeType.PICTURE_FRAME;
    }

    private void initialize() {
        this.initialized = true;
    }

    public final void setObjectId(int n, int n2, int n3) {
        this.objectId = n;
        this.blipId = n2;
        this.shapeId = n3;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    public final int getObjectId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.objectId;
    }

    public int getShapeId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.shapeId;
    }

    public final int getBlipId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.blipId;
    }

    public MsoDrawingRecord getMsoDrawingRecord() {
        return this.msoDrawingRecord;
    }

    public EscherContainer getSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        Assert.verify(this.origin == Origin.READ);
        return this.getReadSpContainer();
    }

    public void setDrawingGroup(DrawingGroup drawingGroup) {
        this.drawingGroup = drawingGroup;
    }

    public DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void setReferenceCount(int n) {
        this.referenceCount = n;
    }

    public double getX() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.x;
    }

    public void setX(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.x = d;
    }

    public double getY() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.y;
    }

    public void setY(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.y = d;
    }

    public double getWidth() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.width;
    }

    public void setWidth(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.width = d;
    }

    public double getHeight() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.height;
    }

    public void setHeight(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.height = d;
    }

    private EscherContainer getReadSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.readSpContainer;
    }

    public byte[] getImageData() {
        Assert.verify(false);
        Assert.verify(this.origin == Origin.READ || this.origin == Origin.READ_WRITE);
        if (!this.initialized) {
            this.initialize();
        }
        return this.drawingGroup.getImageData(this.blipId);
    }

    public byte[] getImageBytes() throws IOException {
        Assert.verify(false);
        if (this.origin == Origin.READ || this.origin == Origin.READ_WRITE) {
            return this.getImageData();
        }
        Assert.verify(this.origin == Origin.WRITE);
        if (this.imageFile == null) {
            Assert.verify(this.imageData != null);
            return this.imageData;
        }
        byte[] byArray = new byte[(int)this.imageFile.length()];
        FileInputStream fileInputStream = new FileInputStream(this.imageFile);
        fileInputStream.read(byArray, 0, byArray.length);
        fileInputStream.close();
        return byArray;
    }

    public ShapeType getType() {
        return this.type;
    }

    public void writeAdditionalRecords(jxl.write.biff.File file) throws IOException {
    }

    public void writeTailRecords(jxl.write.biff.File file) throws IOException {
    }

    public double getColumn() {
        return this.getX();
    }

    public double getRow() {
        return this.getY();
    }

    public boolean isFirst() {
        return this.msoDrawingRecord.isFirst();
    }

    public boolean isFormObject() {
        return false;
    }

    public void removeRow(int n) {
        if (this.y > (double)n) {
            this.setY(n);
        }
    }

    public String getImageFilePath() {
        Assert.verify(false);
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

