/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import java.io.IOException;
import jxl.WorkbookSettings;
import jxl.biff.ContinueRecord;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.drawing.ClientAnchor;
import jxl.biff.drawing.ClientTextBox;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.Origin;
import jxl.biff.drawing.ShapeType;
import jxl.biff.drawing.Sp;
import jxl.biff.drawing.TextObjectRecord;
import jxl.write.biff.File;

public class Button
implements DrawingGroupObject {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$Button == null ? (class$jxl$biff$drawing$Button = Button.class$("jxl.biff.drawing.Button")) : class$jxl$biff$drawing$Button);
    private EscherContainer readSpContainer;
    private EscherContainer spContainer;
    private MsoDrawingRecord msoDrawingRecord;
    private ObjRecord objRecord;
    private boolean initialized = false;
    private int objectId;
    private int blipId;
    private int shapeId;
    private int column;
    private int row;
    private double width;
    private double height;
    private int referenceCount;
    private EscherContainer escherData;
    private Origin origin;
    private DrawingGroup drawingGroup;
    private DrawingData drawingData;
    private ShapeType type;
    private int drawingNumber;
    private MsoDrawingRecord mso;
    private TextObjectRecord txo;
    private ContinueRecord text;
    private ContinueRecord formatting;
    private String commentText;
    private WorkbookSettings workbookSettings;
    static /* synthetic */ Class class$jxl$biff$drawing$Button;

    public Button(MsoDrawingRecord msoDrawingRecord, ObjRecord objRecord, DrawingData drawingData, DrawingGroup drawingGroup, WorkbookSettings workbookSettings) {
        this.drawingGroup = drawingGroup;
        this.msoDrawingRecord = msoDrawingRecord;
        this.drawingData = drawingData;
        this.objRecord = objRecord;
        this.initialized = false;
        this.workbookSettings = workbookSettings;
        this.origin = Origin.READ;
        this.drawingData.addData(this.msoDrawingRecord.getData());
        this.drawingNumber = this.drawingData.getNumDrawings() - 1;
        this.drawingGroup.addDrawing(this);
        Assert.verify(this.msoDrawingRecord != null && this.objRecord != null);
        this.initialize();
    }

    public Button(DrawingGroupObject drawingGroupObject, DrawingGroup drawingGroup, WorkbookSettings workbookSettings) {
        Button button = (Button)drawingGroupObject;
        Assert.verify(button.origin == Origin.READ);
        this.msoDrawingRecord = button.msoDrawingRecord;
        this.objRecord = button.objRecord;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData = button.drawingData;
        this.drawingGroup = drawingGroup;
        this.drawingNumber = button.drawingNumber;
        this.drawingGroup.addDrawing(this);
        this.mso = button.mso;
        this.txo = button.txo;
        this.text = button.text;
        this.formatting = button.formatting;
        this.workbookSettings = workbookSettings;
    }

    private void initialize() {
        this.readSpContainer = this.drawingData.getSpContainer(this.drawingNumber);
        Assert.verify(this.readSpContainer != null);
        EscherRecord[] escherRecordArray = this.readSpContainer.getChildren();
        Sp sp = (Sp)this.readSpContainer.getChildren()[0];
        this.objectId = this.objRecord.getObjectId();
        this.shapeId = sp.getShapeId();
        this.type = ShapeType.getType(sp.getShapeType());
        if (this.type == ShapeType.UNKNOWN) {
            logger.warn("Unknown shape type");
        }
        ClientAnchor clientAnchor = null;
        for (int i = 0; i < escherRecordArray.length && clientAnchor == null; ++i) {
            if (escherRecordArray[i].getType() != EscherRecordType.CLIENT_ANCHOR) continue;
            clientAnchor = (ClientAnchor)escherRecordArray[i];
        }
        if (clientAnchor == null) {
            logger.warn("Client anchor not found");
        } else {
            this.column = (int)clientAnchor.getX1() - 1;
            this.row = (int)clientAnchor.getY1() + 1;
        }
        this.initialized = true;
    }

    public final void setObjectId(int n, int n2, int n3) {
        this.objectId = n;
        this.blipId = n2;
        this.shapeId = n3;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    public final int getObjectId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.objectId;
    }

    public final int getShapeId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.shapeId;
    }

    public final int getBlipId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.blipId;
    }

    public MsoDrawingRecord getMsoDrawingRecord() {
        return this.msoDrawingRecord;
    }

    public EscherContainer getSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.origin == Origin.READ) {
            return this.getReadSpContainer();
        }
        Assert.verify(false);
        return this.spContainer;
    }

    public void setDrawingGroup(DrawingGroup drawingGroup) {
        this.drawingGroup = drawingGroup;
    }

    public DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void setReferenceCount(int n) {
        this.referenceCount = n;
    }

    public double getX() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.column;
    }

    public void setX(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.column = (int)d;
    }

    public double getY() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.row;
    }

    public void setY(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.row = (int)d;
    }

    public double getWidth() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.width;
    }

    public void setWidth(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.width = d;
    }

    public double getHeight() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.height;
    }

    public void setHeight(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.height = d;
    }

    private EscherContainer getReadSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.readSpContainer;
    }

    public byte[] getImageData() {
        Assert.verify(this.origin == Origin.READ || this.origin == Origin.READ_WRITE);
        if (!this.initialized) {
            this.initialize();
        }
        return this.drawingGroup.getImageData(this.blipId);
    }

    public ShapeType getType() {
        return this.type;
    }

    public void setTextObject(TextObjectRecord textObjectRecord) {
        this.txo = textObjectRecord;
    }

    public void setText(ContinueRecord continueRecord) {
        this.text = continueRecord;
    }

    public void setFormatting(ContinueRecord continueRecord) {
        this.formatting = continueRecord;
    }

    public byte[] getImageBytes() {
        Assert.verify(false);
        return null;
    }

    public String getImageFilePath() {
        Assert.verify(false);
        return null;
    }

    public void addMso(MsoDrawingRecord msoDrawingRecord) {
        this.mso = msoDrawingRecord;
        this.drawingData.addRawData(this.mso.getData());
    }

    public void writeAdditionalRecords(File file) throws IOException {
        if (this.origin == Origin.READ) {
            file.write(this.objRecord);
            if (this.mso != null) {
                file.write(this.mso);
            }
            file.write(this.txo);
            file.write(this.text);
            if (this.formatting != null) {
                file.write(this.formatting);
            }
            return;
        }
        Assert.verify(false);
        ObjRecord objRecord = new ObjRecord(this.objectId, ObjRecord.EXCELNOTE);
        file.write(objRecord);
        ClientTextBox clientTextBox = new ClientTextBox();
        MsoDrawingRecord msoDrawingRecord = new MsoDrawingRecord(clientTextBox.getData());
        file.write(msoDrawingRecord);
        TextObjectRecord textObjectRecord = new TextObjectRecord(this.getText());
        file.write(textObjectRecord);
        byte[] byArray = new byte[this.commentText.length() * 2 + 1];
        byArray[0] = 1;
        StringHelper.getUnicodeBytes(this.commentText, byArray, 1);
        ContinueRecord continueRecord = new ContinueRecord(byArray);
        file.write(continueRecord);
        byte[] byArray2 = new byte[16];
        IntegerHelper.getTwoBytes(0, byArray2, 0);
        IntegerHelper.getTwoBytes(0, byArray2, 2);
        IntegerHelper.getTwoBytes(this.commentText.length(), byArray2, 8);
        IntegerHelper.getTwoBytes(0, byArray2, 10);
        ContinueRecord continueRecord2 = new ContinueRecord(byArray2);
        file.write(continueRecord2);
    }

    public void writeTailRecords(File file) {
    }

    public int getRow() {
        return 0;
    }

    public int getColumn() {
        return 0;
    }

    public String getText() {
        if (this.commentText == null) {
            Assert.verify(this.text != null);
            byte[] byArray = this.text.getData();
            this.commentText = byArray[0] == 0 ? StringHelper.getString(byArray, byArray.length - 1, 1, this.workbookSettings) : StringHelper.getUnicodeString(byArray, (byArray.length - 1) / 2, 1);
        }
        return this.commentText;
    }

    public int hashCode() {
        return this.commentText.hashCode();
    }

    public void setButtonText(String string) {
        this.commentText = string;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    public boolean isFirst() {
        return this.mso.isFirst();
    }

    public boolean isFormObject() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

