/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import java.io.IOException;
import jxl.biff.IntegerHelper;
import jxl.biff.drawing.BlipType;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;

class BlipStoreEntry
extends EscherAtom {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$BlipStoreEntry == null ? (class$jxl$biff$drawing$BlipStoreEntry = BlipStoreEntry.class$("jxl.biff.drawing.BlipStoreEntry")) : class$jxl$biff$drawing$BlipStoreEntry);
    private BlipType type;
    private byte[] data;
    private int imageDataLength;
    private int referenceCount;
    private boolean write;
    private static final int IMAGE_DATA_OFFSET = 61;
    static /* synthetic */ Class class$jxl$biff$drawing$BlipStoreEntry;

    public BlipStoreEntry(EscherRecordData escherRecordData) {
        super(escherRecordData);
        this.type = BlipType.getType(this.getInstance());
        this.write = false;
        byte[] byArray = this.getBytes();
        this.referenceCount = IntegerHelper.getInt(byArray[24], byArray[25], byArray[26], byArray[27]);
    }

    public BlipStoreEntry(Drawing drawing) throws IOException {
        super(EscherRecordType.BSE);
        this.type = BlipType.PNG;
        this.setVersion(2);
        this.setInstance(this.type.getValue());
        byte[] byArray = drawing.getImageBytes();
        this.imageDataLength = byArray.length;
        this.data = new byte[this.imageDataLength + 61];
        System.arraycopy(byArray, 0, this.data, 61, this.imageDataLength);
        this.referenceCount = drawing.getReferenceCount();
        this.write = true;
    }

    public BlipType getBlipType() {
        return this.type;
    }

    public byte[] getData() {
        if (this.write) {
            this.data[0] = (byte)this.type.getValue();
            this.data[1] = (byte)this.type.getValue();
            IntegerHelper.getFourBytes(this.imageDataLength + 8 + 17, this.data, 20);
            IntegerHelper.getFourBytes(this.referenceCount, this.data, 24);
            IntegerHelper.getFourBytes(0, this.data, 28);
            this.data[32] = 0;
            this.data[33] = 0;
            this.data[34] = 126;
            this.data[35] = 1;
            this.data[36] = 0;
            this.data[37] = 110;
            IntegerHelper.getTwoBytes(61470, this.data, 38);
            IntegerHelper.getFourBytes(this.imageDataLength + 17, this.data, 40);
        } else {
            this.data = this.getBytes();
        }
        return this.setHeaderData(this.data);
    }

    void dereference() {
        --this.referenceCount;
        Assert.verify(this.referenceCount >= 0);
    }

    int getReferenceCount() {
        return this.referenceCount;
    }

    byte[] getImageData() {
        byte[] byArray = this.getBytes();
        byte[] byArray2 = new byte[byArray.length - 61];
        System.arraycopy(byArray, 61, byArray2, 0, byArray2.length);
        return byArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

