/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.format.Colour;
import jxl.format.RGB;
import jxl.read.biff.Record;

public class PaletteRecord
extends WritableRecordData {
    private RGB[] rgbColours = new RGB[56];
    private boolean dirty;
    private boolean read;
    private boolean initialized;
    private static final int numColours = 56;

    public PaletteRecord(Record record) {
        super(record);
        this.initialized = false;
        this.dirty = false;
        this.read = true;
    }

    public PaletteRecord() {
        super(Type.PALETTE);
        this.initialized = true;
        this.dirty = false;
        this.read = false;
        Colour[] colourArray = Colour.getAllColours();
        for (int i = 0; i < colourArray.length; ++i) {
            Colour colour = colourArray[i];
            this.setColourRGB(colour, colour.getDefaultRGB().getRed(), colour.getDefaultRGB().getGreen(), colour.getDefaultRGB().getBlue());
        }
    }

    public byte[] getData() {
        if (this.read && !this.dirty) {
            return this.getRecord().getData();
        }
        byte[] byArray = new byte[226];
        int n = 0;
        IntegerHelper.getTwoBytes(56, byArray, n);
        for (int i = 0; i < 56; ++i) {
            n = i * 4 + 2;
            byArray[n] = (byte)this.rgbColours[i].getRed();
            byArray[n + 1] = (byte)this.rgbColours[i].getGreen();
            byArray[n + 2] = (byte)this.rgbColours[i].getBlue();
        }
        return byArray;
    }

    private void initialize() {
        byte[] byArray = this.getRecord().getData();
        int n = IntegerHelper.getInt(byArray[0], byArray[1]);
        for (int i = 0; i < n; ++i) {
            int n2 = i * 4 + 2;
            int n3 = IntegerHelper.getInt(byArray[n2], (byte)0);
            int n4 = IntegerHelper.getInt(byArray[n2 + 1], (byte)0);
            int n5 = IntegerHelper.getInt(byArray[n2 + 2], (byte)0);
            this.rgbColours[i] = new RGB(n3, n4, n5);
        }
        this.initialized = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setColourRGB(Colour colour, int n, int n2, int n3) {
        int n4 = colour.getValue() - 8;
        if (n4 < 0 || n4 >= 56) {
            return;
        }
        if (!this.initialized) {
            this.initialize();
        }
        n = this.setValueRange(n, 0, 255);
        n2 = this.setValueRange(n2, 0, 255);
        n3 = this.setValueRange(n3, 0, 255);
        this.rgbColours[n4] = new RGB(n, n2, n3);
        this.dirty = true;
    }

    public RGB getColourRGB(Colour colour) {
        int n = colour.getValue() - 8;
        if (n < 0 || n >= 56) {
            return colour.getDefaultRGB();
        }
        if (!this.initialized) {
            this.initialize();
        }
        return this.rgbColours[n];
    }

    private int setValueRange(int n, int n2, int n3) {
        n = Math.max(n, n2);
        n = Math.min(n, n3);
        return n;
    }
}

