/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.DVParser;
import jxl.biff.DataValidation;
import jxl.biff.Type;
import jxl.biff.WorkbookMethods;
import jxl.biff.WritableRecordData;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.read.biff.Record;

public class DataValiditySettingsRecord
extends WritableRecordData {
    private static Logger logger = Logger.getLogger(class$jxl$biff$DataValiditySettingsRecord == null ? (class$jxl$biff$DataValiditySettingsRecord = DataValiditySettingsRecord.class$("jxl.biff.DataValiditySettingsRecord")) : class$jxl$biff$DataValiditySettingsRecord);
    private byte[] data;
    private DVParser dvParser;
    private WorkbookMethods workbook;
    private ExternalSheet externalSheet;
    private WorkbookSettings workbookSettings;
    private DataValidation dataValidation;
    static /* synthetic */ Class class$jxl$biff$DataValiditySettingsRecord;

    public DataValiditySettingsRecord(Record record, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) {
        super(record);
        this.data = record.getData();
        this.externalSheet = externalSheet;
        this.workbook = workbookMethods;
        this.workbookSettings = workbookSettings;
    }

    DataValiditySettingsRecord(DataValiditySettingsRecord dataValiditySettingsRecord) {
        super(Type.DV);
        this.data = dataValiditySettingsRecord.getData();
    }

    DataValiditySettingsRecord(DataValiditySettingsRecord dataValiditySettingsRecord, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) {
        super(Type.DV);
        this.workbook = workbookMethods;
        this.externalSheet = externalSheet;
        this.workbookSettings = workbookSettings;
        Assert.verify(workbookMethods != null);
        Assert.verify(externalSheet != null);
        this.data = new byte[dataValiditySettingsRecord.data.length];
        System.arraycopy(dataValiditySettingsRecord.data, 0, this.data, 0, this.data.length);
    }

    public DataValiditySettingsRecord(DVParser dVParser) {
        super(Type.DV);
        this.dvParser = dVParser;
    }

    private void initialize() {
        try {
            if (this.dvParser == null) {
                this.dvParser = new DVParser(this.data, this.externalSheet, this.workbook, this.workbookSettings);
            }
        }
        catch (FormulaException formulaException) {
            logger.warn("Cannot read drop down range " + formulaException.getMessage());
        }
    }

    public byte[] getData() {
        if (this.dvParser == null) {
            return this.data;
        }
        return this.dvParser.getData();
    }

    public void insertRow(int n) {
        if (this.dvParser == null) {
            this.initialize();
        }
        this.dvParser.insertRow(n);
    }

    public void removeRow(int n) {
        if (this.dvParser == null) {
            this.initialize();
        }
        this.dvParser.removeRow(n);
    }

    public void insertColumn(int n) {
        if (this.dvParser == null) {
            this.initialize();
        }
        this.dvParser.insertColumn(n);
    }

    public void removeColumn(int n) {
        if (this.dvParser == null) {
            this.initialize();
        }
        this.dvParser.removeColumn(n);
    }

    public int getFirstColumn() {
        if (this.dvParser == null) {
            this.initialize();
        }
        return this.dvParser.getFirstColumn();
    }

    public int getLastColumn() {
        if (this.dvParser == null) {
            this.initialize();
        }
        return this.dvParser.getLastColumn();
    }

    public int getFirstRow() {
        if (this.dvParser == null) {
            this.initialize();
        }
        return this.dvParser.getFirstRow();
    }

    public int getLastRow() {
        if (this.dvParser == null) {
            this.initialize();
        }
        return this.dvParser.getLastRow();
    }

    void setDataValidation(DataValidation dataValidation) {
        this.dataValidation = dataValidation;
    }

    DVParser getDVParser() {
        return this.dvParser;
    }

    public String getValidationFormula() {
        try {
            if (this.dvParser == null) {
                this.initialize();
            }
            return this.dvParser.getValidationFormula();
        }
        catch (FormulaException formulaException) {
            logger.warn("Cannot read drop down range " + formulaException.getMessage());
            return "";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

