/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

public class ByteArray {
    private int growSize;
    private byte[] bytes;
    private int pos;
    private static final int defaultGrowSize = 1024;

    public ByteArray() {
        this(1024);
    }

    public ByteArray(int n) {
        this.growSize = n;
        this.bytes = new byte[1024];
        this.pos = 0;
    }

    public void add(byte by) {
        this.checkSize(1);
        this.bytes[this.pos] = by;
        ++this.pos;
    }

    public void add(byte[] byArray) {
        this.checkSize(byArray.length);
        System.arraycopy(byArray, 0, this.bytes, this.pos, byArray.length);
        this.pos += byArray.length;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.bytes, 0, byArray, 0, this.pos);
        return byArray;
    }

    private void checkSize(int n) {
        while (this.pos + n >= this.bytes.length) {
            byte[] byArray = new byte[this.bytes.length + this.growSize];
            System.arraycopy(this.bytes, 0, byArray, 0, this.pos);
            this.bytes = byArray;
        }
    }
}

