/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import jxl.read.biff.File;
import jxl.read.biff.PasswordException;
import jxl.read.biff.WorkbookParser;
import jxl.write.WritableWorkbook;
import jxl.write.biff.WritableWorkbookImpl;

public abstract class Workbook {
    private static final String VERSION = "2.6.6";

    protected Workbook() {
    }

    public abstract Sheet[] getSheets();

    public abstract String[] getSheetNames();

    public abstract Sheet getSheet(int var1) throws IndexOutOfBoundsException;

    public abstract Sheet getSheet(String var1);

    public static String getVersion() {
        return VERSION;
    }

    public abstract int getNumberOfSheets();

    public abstract Cell findCellByName(String var1);

    public abstract Cell getCell(String var1);

    public abstract Range[] findByName(String var1);

    public abstract String[] getRangeNames();

    public abstract boolean isProtected();

    protected abstract void parse() throws BiffException, PasswordException;

    public abstract void close();

    public static Workbook getWorkbook(java.io.File file) throws IOException, BiffException {
        return Workbook.getWorkbook(file, new WorkbookSettings());
    }

    public static Workbook getWorkbook(java.io.File file, WorkbookSettings workbookSettings) throws IOException, BiffException {
        FileInputStream fileInputStream = new FileInputStream(file);
        File file2 = null;
        try {
            file2 = new File(fileInputStream, workbookSettings);
        }
        catch (IOException iOException) {
            fileInputStream.close();
            throw iOException;
        }
        catch (BiffException biffException) {
            fileInputStream.close();
            throw biffException;
        }
        fileInputStream.close();
        WorkbookParser workbookParser = new WorkbookParser(file2, workbookSettings);
        ((Workbook)workbookParser).parse();
        return workbookParser;
    }

    public static Workbook getWorkbook(InputStream inputStream) throws IOException, BiffException {
        return Workbook.getWorkbook(inputStream, new WorkbookSettings());
    }

    public static Workbook getWorkbook(InputStream inputStream, WorkbookSettings workbookSettings) throws IOException, BiffException {
        File file = new File(inputStream, workbookSettings);
        WorkbookParser workbookParser = new WorkbookParser(file, workbookSettings);
        ((Workbook)workbookParser).parse();
        return workbookParser;
    }

    public static WritableWorkbook createWorkbook(java.io.File file) throws IOException {
        return Workbook.createWorkbook(file, new WorkbookSettings());
    }

    public static WritableWorkbook createWorkbook(java.io.File file, WorkbookSettings workbookSettings) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        WritableWorkbookImpl writableWorkbookImpl = new WritableWorkbookImpl(fileOutputStream, true, workbookSettings);
        return writableWorkbookImpl;
    }

    public static WritableWorkbook createWorkbook(java.io.File file, Workbook workbook) throws IOException {
        return Workbook.createWorkbook(file, workbook, new WorkbookSettings());
    }

    public static WritableWorkbook createWorkbook(java.io.File file, Workbook workbook, WorkbookSettings workbookSettings) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        WritableWorkbookImpl writableWorkbookImpl = new WritableWorkbookImpl(fileOutputStream, workbook, true, workbookSettings);
        return writableWorkbookImpl;
    }

    public static WritableWorkbook createWorkbook(OutputStream outputStream, Workbook workbook) throws IOException {
        return Workbook.createWorkbook(outputStream, workbook, ((WorkbookParser)workbook).getSettings());
    }

    public static WritableWorkbook createWorkbook(OutputStream outputStream, Workbook workbook, WorkbookSettings workbookSettings) throws IOException {
        WritableWorkbookImpl writableWorkbookImpl = new WritableWorkbookImpl(outputStream, workbook, false, workbookSettings);
        return writableWorkbookImpl;
    }

    public static WritableWorkbook createWorkbook(OutputStream outputStream) throws IOException {
        return Workbook.createWorkbook(outputStream, new WorkbookSettings());
    }

    public static WritableWorkbook createWorkbook(OutputStream outputStream, WorkbookSettings workbookSettings) throws IOException {
        WritableWorkbookImpl writableWorkbookImpl = new WritableWorkbookImpl(outputStream, false, workbookSettings);
        return writableWorkbookImpl;
    }
}

