/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.log.LoggerName;
import common.log.SimpleLogger;
import java.security.AccessControlException;

public abstract class Logger {
    private static Logger logger = null;

    public static final Logger getLogger(Class clazz) {
        if (logger == null) {
            Logger.initializeLogger();
        }
        return logger.getLoggerImpl(clazz);
    }

    private static synchronized void initializeLogger() {
        if (logger != null) {
            return;
        }
        String string = LoggerName.NAME;
        try {
            string = System.getProperty("logger");
            if (string == null) {
                string = LoggerName.NAME;
            }
            logger = (Logger)Class.forName(string).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            logger = new SimpleLogger();
            logger.warn("Could not instantiate logger " + string + " using default");
        }
        catch (InstantiationException instantiationException) {
            logger = new SimpleLogger();
            logger.warn("Could not instantiate logger " + string + " using default");
        }
        catch (AccessControlException accessControlException) {
            logger = new SimpleLogger();
            logger.warn("Could not instantiate logger " + string + " using default");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger = new SimpleLogger();
            logger.warn("Could not instantiate logger " + string + " using default");
        }
    }

    protected Logger() {
    }

    public abstract void debug(Object var1);

    public abstract void debug(Object var1, Throwable var2);

    public abstract void error(Object var1);

    public abstract void error(Object var1, Throwable var2);

    public abstract void fatal(Object var1);

    public abstract void fatal(Object var1, Throwable var2);

    public abstract void info(Object var1);

    public abstract void info(Object var1, Throwable var2);

    public abstract void warn(Object var1);

    public abstract void warn(Object var1, Throwable var2);

    protected abstract Logger getLoggerImpl(Class var1);

    public void setSuppressWarnings(boolean bl) {
    }
}

