/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class IntervalYM
extends Interval {
    private static final ThreadLocal<Calendar> localCalendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };
    protected long months;
    private String locale = null;
    protected static final int MonthsPerYear = 12;

    public IntervalYM() throws SQLException {
        this.setQualifier((byte)4, (byte)0, (byte)2);
    }

    public IntervalYM(Connection connection) throws SQLException {
        this();
        this.setConnection(connection);
    }

    public IntervalYM(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        this.setQualifier((byte)4, (byte)0, (byte)2);
        this.set(timestamp, timestamp2);
    }

    public IntervalYM(Timestamp timestamp, Timestamp timestamp2, Connection connection) throws SQLException {
        this(timestamp, timestamp2);
        this.setConnection(connection);
    }

    public IntervalYM(int n2, int n3) throws SQLException {
        this.setQualifier((byte)4, (byte)0, (byte)2);
        this.set(n2, n3);
    }

    public IntervalYM(int n2, int n3, Connection connection) throws SQLException {
        this(n2, n3);
        this.setConnection(connection);
    }

    public IntervalYM(int n2, short s2) throws SQLException {
        this.setQualifier(s2);
        this.months = n2;
    }

    public IntervalYM(int n2, short s2, Connection connection) throws SQLException {
        this(n2, s2);
        this.setConnection(connection);
    }

    public IntervalYM(String string) throws SQLException {
        this.setQualifier((byte)4, (byte)0, (byte)2);
        this.set(string);
    }

    public IntervalYM(String string, Connection connection) throws SQLException {
        this(string);
        this.setConnection(connection);
    }

    public IntervalYM(String string, short s2) throws SQLException {
        this.setQualifier(s2);
        this.set(string);
    }

    public IntervalYM(String string, short s2, Connection connection) throws SQLException {
        this(string, s2);
        this.setConnection(connection);
    }

    public IntervalYM(String string, int n2, byte by, byte by2) throws SQLException {
        this.setQualifier((byte)n2, by, by2);
        this.set(string);
    }

    public IntervalYM(String string, int n2, byte by, byte by2, Connection connection) throws SQLException {
        this(string, n2, by, by2);
        this.setConnection(connection);
    }

    public void set(Timestamp timestamp, Timestamp timestamp2) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)localCalendar.get();
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)localCalendar.get();
        gregorianCalendar.setTime(timestamp);
        gregorianCalendar2.setTime(timestamp2);
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar2.get(1);
        int n4 = gregorianCalendar.get(2);
        int n5 = gregorianCalendar2.get(2);
        int n6 = n2 - n3;
        int n7 = n4 - n5;
        this.set(n6, n7);
    }

    public void set(int n2, int n3) {
        if (n2 < 0) {
            if (n3 > 0) {
                ++n2;
                n3 -= 12;
            }
        } else if (n3 < 0 && n2 > 0) {
            --n2;
            n3 += 12;
        }
        this.months = n3 + n2 * 12;
    }

    public void set(String string) throws SQLException {
        this.fromString(string);
    }

    public String toString() {
        String string;
        short s2 = this.getQualifier();
        byte by = IntervalYM.getEndCode(s2);
        byte by2 = IntervalYM.getStartCode(s2);
        long l2 = this.months;
        boolean bl = false;
        if (l2 < 0L) {
            bl = true;
            l2 = -l2;
        }
        if (by2 == 0 && by == 2) {
            String string2 = String.valueOf(l2 / 12L);
            String string3 = "";
            if (l2 % 12L < 10L) {
                string3 = "0";
            }
            string3 = string3 + String.valueOf(l2 % 12L);
            string = string2 + dtdelim[0] + string3;
        } else if (by2 == 0) {
            string = String.valueOf(l2 / 12L);
        } else if (by2 == 2) {
            string = String.valueOf(l2);
        } else {
            throw new NumberFormatException("Invalid qualifier for IntervalYM");
        }
        if (bl) {
            string = "-" + string;
        }
        return string;
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            return;
        }
        short s2 = this.getQualifier();
        string = string.trim();
        boolean bl = false;
        if (string.length() > 0 && (string.charAt(0) == '-' || string.charAt(0) == '+')) {
            if (string.length() == 1) {
                throw IfxErrMsg.getLocSQLException(-79706, this.locale);
            }
            if (string.charAt(0) == '-') {
                bl = true;
            }
            string = string.substring(1);
        }
        int[] nArray = this.stringToUnits(string, s2);
        this.months = nArray[0] * 12 + nArray[1];
        if (bl) {
            this.months = -this.months;
        }
    }

    public long getMonths() {
        return this.months;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof IntervalYM && object != null) {
            bl = this.months == ((IntervalYM)object).getMonths();
        }
        return bl;
    }

    public boolean greaterThan(IntervalYM intervalYM) {
        return intervalYM != null && this.months > intervalYM.getMonths();
    }

    public boolean lessThan(IntervalYM intervalYM) {
        return intervalYM != null && this.months < intervalYM.getMonths();
    }

    public void setQualifier(byte by, byte by2, byte by3) throws SQLException {
        if (by2 > 2 || by3 > 2 || by2 > by3) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = (short)(by3 - by2 + by << 8 | by2 << 4 | by3);
    }

    public void setQualifier(short s2) throws SQLException {
        byte by = IntervalYM.getStartCode(s2);
        byte by2 = IntervalYM.getEndCode(s2);
        if (by > 2 || by2 > 2 || by > by2) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = s2;
    }
}

