/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jns;

import java.util.Properties;

public class OptsTokenizer {
    final int COMA = 44;
    final int OPAR = 40;
    final int CPAR = 41;
    final int CMTCHAR = 35;
    final int EQUALCHAR = 61;
    private char[] pca;
    private int cidx;
    private int slen;

    public OptsTokenizer(String string) {
        String string2 = string.trim();
        this.slen = string2.length();
        this.pca = string2.toCharArray();
        this.cidx = 0;
        this.skipWS();
    }

    public Properties getOpts() {
        String string;
        Properties properties = new Properties();
        while ((string = this.getNextToken()).length() != 0) {
            int n2 = string.indexOf(61);
            if (n2 == -1) {
                properties.put(string, "");
                continue;
            }
            properties.put(string.substring(0, n2), string.substring(n2 + 1));
        }
        return properties;
    }

    private void skipWS() {
        while (this.cidx < this.slen && (Character.isWhitespace(this.pca[this.cidx]) || this.pca[this.cidx] == ',')) {
            ++this.cidx;
        }
    }

    private String getNextToken() {
        int n2 = this.cidx;
        while (this.cidx < this.slen) {
            if (this.pca[this.cidx] == '#') {
                return new String(this.pca, n2, this.cidx - n2);
            }
            if (this.pca[this.cidx] == '(') {
                this.matchPar();
                continue;
            }
            if (Character.isWhitespace(this.pca[this.cidx]) || this.pca[this.cidx] == ',') {
                String string = new String(this.pca, n2, this.cidx - n2);
                this.skipWS();
                return string;
            }
            ++this.cidx;
        }
        return new String(this.pca, n2, this.cidx - n2);
    }

    private void matchPar() {
        int n2 = 0;
        while (this.cidx < this.slen) {
            if (this.pca[this.cidx] == '(') {
                ++this.cidx;
                ++n2;
                continue;
            }
            if (this.pca[this.cidx] == ')') {
                ++this.cidx;
                if (--n2 != 0) continue;
                return;
            }
            if (this.pca[this.cidx] == '#') {
                return;
            }
            ++this.cidx;
        }
    }
}

