/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.MaintenanceManager;
import org.firebirdsql.util.NumericHelper;

public class FBMaintenanceManager
extends FBServiceManager
implements MaintenanceManager {
    public FBMaintenanceManager() {
    }

    public FBMaintenanceManager(String gdsType) {
        super(gdsType);
    }

    public FBMaintenanceManager(GDSType gdsType) {
        super(gdsType);
    }

    @Override
    public void setDatabaseAccessMode(int mode) throws SQLException {
        if (mode != 40 && mode != 39) {
            throw new IllegalArgumentException("mode must be one of ACCESS_MODE_READ_WRITE or ACCESS_MODE_READ_ONLY");
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultPropertiesSRB(service);
            srb.addArgument(13, (byte)mode);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void setDatabaseDialect(int dialect) throws SQLException {
        if (dialect != 1 && dialect != 3) {
            throw new IllegalArgumentException("dialect must be either 1 or 3");
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultPropertiesSRB(service);
            srb.addArgument(14, dialect);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void setDefaultCacheBuffer(int pageCount) throws SQLException {
        if (pageCount != 0 && pageCount < 50) {
            throw new IllegalArgumentException("page count must be 0 or >= 50, value was: " + pageCount);
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultPropertiesSRB(service);
            srb.addArgument(5, pageCount);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void setForcedWrites(boolean forced) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultPropertiesSRB(service);
            srb.addArgument(12, (byte)(forced ? 38 : 37));
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void setPageFill(int pageFill) throws SQLException {
        if (pageFill != 35 && pageFill != 36) {
            throw new IllegalArgumentException("Page fill must be either PAGE_FILL_FULL or PAGE_FILL_RESERVE");
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultPropertiesSRB(service);
            srb.addArgument(11, (byte)pageFill);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void shutdownDatabase(int shutdownMode, int timeout) throws SQLException {
        if (shutdownMode != 9 && shutdownMode != 10 && shutdownMode != 7) {
            throw new IllegalArgumentException("Shutdown mode must be one of: SHUTDOWN_ATTACH, SHUTDOWN_TRANSACTIONAL, SHUTDOWN_FORCE");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultPropertiesSRB(service);
            srb.addArgument(shutdownMode, timeout);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void shutdownDatabase(byte operationMode, int shutdownModeEx, int timeout) throws SQLException {
        if (operationMode != 1 && operationMode != 2 && operationMode != 3) {
            throw new IllegalArgumentException("Operation mode must be one of: OPERATION_MODE_MULTI, OPERATION_MODE_SINGLE, OPERATION_MODE_FULL_SHUTDOWN");
        }
        if (shutdownModeEx != 41 && shutdownModeEx != 42 && shutdownModeEx != 43) {
            throw new IllegalArgumentException("Extended shutdown mode must be one of: SHUTDOWNEX_FORCE, SHUTDOWNEX_ATTACHMENTS, SHUTDOWNEX_TRANSACTIONS");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultPropertiesSRB(service);
            srb.addArgument(44, operationMode);
            srb.addArgument(shutdownModeEx, timeout);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void bringDatabaseOnline() throws SQLException {
        this.executePropertiesOperation(512);
    }

    @Override
    public void bringDatabaseOnline(byte operationMode) throws SQLException {
        if (operationMode != 0 && operationMode != 1 && operationMode != 2) {
            throw new IllegalArgumentException("Operation mode must be one of: OPERATION_MODE_NORMAL, OPERATION_MODE_MULTI, OPERATION_MODE_SINGLE");
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultPropertiesSRB(service);
            srb.addArgument(45, operationMode);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void markCorruptRecords() throws SQLException {
        this.executeRepairOperation(4);
    }

    @Override
    public void validateDatabase() throws SQLException {
        this.executeRepairOperation(1);
    }

    @Override
    public void validateDatabase(int options) throws SQLException {
        if (options < 0 || options != 0 && options != 32 && (options & 0xFFFFFFDF) != 16 && (options & 0xFFFFFFDF) != 128 && (options | 0x30) != options && (options | 0xA0) != options) {
            throw new IllegalArgumentException("options must be either 0, VALIDATE_READ_ONLY, or VALIDATE_FULL, optionally combined with VALIDATE_IGNORE_CHECKSUM");
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createRepairSRB(service, options | 1);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void setSweepThreshold(int transactions) throws SQLException {
        if (transactions < 0) {
            throw new IllegalArgumentException("transactions must be >= 0");
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultPropertiesSRB(service);
            srb.addArgument(6, transactions);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void sweepDatabase() throws SQLException {
        this.executeRepairOperation(2);
    }

    @Override
    public void activateShadowFile() throws SQLException {
        this.executePropertiesOperation(256);
    }

    @Override
    public void killUnavailableShadows() throws SQLException {
        this.executeRepairOperation(64);
    }

    @Override
    @Deprecated
    public void listLimboTransactions() throws SQLException {
        PrintStream ps = new PrintStream(this.getLogger());
        for (Long trId : this.limboTransactionsAsList()) {
            ps.print(trId + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> limboTransactionsAsList() throws SQLException {
        byte[] output;
        OutputStream saveOut = this.getLogger();
        ArrayList<Long> result = new ArrayList<Long>();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.setLogger(out);
            this.executeRepairOperation(8);
            output = out.toByteArray();
        }
        finally {
            this.setLogger(saveOut);
        }
        int idx = 0;
        block11: while (idx < output.length) {
            switch (output[idx++]) {
                case 19: 
                case 20: {
                    long trId = VaxEncoding.iscVaxLong(output, idx, 4);
                    idx += 4;
                    result.add(trId);
                    continue block11;
                }
                case 47: 
                case 48: {
                    long trId = VaxEncoding.iscVaxLong(output, idx, 8);
                    idx += 8;
                    result.add(trId);
                    continue block11;
                }
                case 18: {
                    idx += 4;
                    continue block11;
                }
                case 46: {
                    idx += 8;
                    continue block11;
                }
                case 21: 
                case 29: {
                    ++idx;
                    continue block11;
                }
                case 26: 
                case 27: 
                case 28: {
                    int length = VaxEncoding.iscVaxInteger2(output, idx);
                    idx += 2;
                    idx += length;
                    continue block11;
                }
            }
            throw new FbExceptionBuilder().exception(336986116).messageParameter(output[idx - 1] & 0xFF).toSQLException();
        }
        return result;
    }

    @Override
    public long[] getLimboTransactions() throws SQLException {
        List<Long> limboTransactions = this.limboTransactionsAsList();
        long[] trans = new long[limboTransactions.size()];
        int idx = 0;
        for (long trId : limboTransactions) {
            trans[idx++] = trId;
        }
        return trans;
    }

    @Override
    public void commitTransaction(long transactionId) throws SQLException {
        this.handleTransaction(transactionId, 15, 49);
    }

    @Override
    public void rollbackTransaction(long transactionId) throws SQLException {
        this.handleTransaction(transactionId, 34, 50);
    }

    private void handleTransaction(long transactionId, int action32bit, int action64bit) throws SQLException {
        if (transactionId < 0L) {
            throw new SQLException("Only positive transactionIds are supported");
        }
        boolean is32Bit = NumericHelper.fitsUnsigned32BitInteger(transactionId);
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultRepairSRB(service);
            srb.addArgument(is32Bit ? action32bit : action64bit, transactionId);
            this.executeServicesOperation(service, srb);
        }
    }

    private void executeRepairOperation(int operation) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createRepairSRB(service, operation);
            this.executeServicesOperation(service, srb);
        }
    }

    private void executePropertiesOperation(int operation) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createPropertiesSRB(service, operation);
            this.executeServicesOperation(service, srb);
        }
    }

    private ServiceRequestBuffer createDefaultPropertiesSRB(FbService service) {
        return this.createPropertiesSRB(service, 0);
    }

    private ServiceRequestBuffer createDefaultRepairSRB(FbService service) {
        return this.createRepairSRB(service, 0);
    }

    private ServiceRequestBuffer createPropertiesSRB(FbService service, int options) {
        return this.createRequestBuffer(service, 8, options);
    }

    private ServiceRequestBuffer createRepairSRB(FbService service, int options) {
        return this.createRequestBuffer(service, 3, options);
    }
}

