/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Set;

interface GeneratedKeysSupport {
    public Query buildQuery(String var1, int var2) throws SQLException;

    public Query buildQuery(String var1, int[] var2) throws SQLException;

    public Query buildQuery(String var1, String[] var2) throws SQLException;

    public Set<QueryType> supportedQueryTypes();

    public boolean supportsGetGeneratedKeys();

    public static final class Query {
        private final boolean generatesKeys;
        private final String queryString;

        Query(boolean generatesKeys, String queryString) {
            this.generatesKeys = generatesKeys;
            this.queryString = queryString;
        }

        boolean generatesKeys() {
            return this.generatesKeys;
        }

        String getQueryString() {
            return this.queryString;
        }
    }

    public static enum QueryType {
        INSERT(2, 0, "insert"),
        UPDATE(2, 1, "update"),
        DELETE(2, 1, "delete"),
        MERGE(3, 0, "merge"),
        UPDATE_OR_INSERT(2, 1, "update_or_insert"),
        UNSUPPORTED(Integer.MAX_VALUE, Integer.MAX_VALUE, "unsupported");

        private final int sinceMajor;
        private final int sinceMinor;
        private final String configName;

        private QueryType(int sinceMajor, int sinceMinor, String configName) {
            this.sinceMajor = sinceMajor;
            this.sinceMinor = sinceMinor;
            this.configName = configName;
        }

        boolean matches(String name) {
            return this.configName.equals(name);
        }

        static Set<QueryType> returningSupportForVersion(int major, int minor) {
            EnumSet<QueryType> supportedQueryTypes = EnumSet.noneOf(QueryType.class);
            for (QueryType queryType : QueryType.values()) {
                if (major <= queryType.sinceMajor && (major != queryType.sinceMajor || minor < queryType.sinceMinor)) continue;
                supportedQueryTypes.add(queryType);
            }
            return supportedQueryTypes;
        }
    }
}

