/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;

public final class KnownServerKey {
    private static final Pattern CRYPT_PLUGIN_LIST_SPLIT = Pattern.compile("[ \t,;]+");
    private final String keyType;
    private final List<String> plugins;

    public KnownServerKey(String keyType, List<String> plugins) {
        this.keyType = Objects.requireNonNull(keyType, "keyType");
        this.plugins = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(plugins, "plugins")));
    }

    public KnownServerKey(String keyType, String plugins) {
        this(keyType, Arrays.asList(CRYPT_PLUGIN_LIST_SPLIT.split(plugins)));
    }

    public List<EncryptionIdentifier> getIdentifiers() {
        ArrayList<EncryptionIdentifier> identifiers = new ArrayList<EncryptionIdentifier>(this.plugins.size());
        for (String plugin : this.plugins) {
            identifiers.add(new EncryptionIdentifier(this.keyType, plugin));
        }
        return identifiers;
    }
}

