/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.dbcrypt.simple;

import java.nio.charset.StandardCharsets;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallbackSpi;
import org.firebirdsql.gds.ng.dbcrypt.simple.StaticValueDbCryptCallback;
import org.firebirdsql.util.ByteArrayHelper;

public final class StaticValueDbCryptCallbackSpi
implements DbCryptCallbackSpi {
    static final String NAME = "StaticValue";
    private static final String BASE64_PREFIX = "base64:";
    private static final int BASE64_PREFIX_LENGTH = 7;

    @Override
    public String getDbCryptCallbackName() {
        return NAME;
    }

    @Override
    public DbCryptCallback createDbCryptCallback(String dbCryptConfig) {
        if (dbCryptConfig == null) {
            return StaticValueDbCryptCallback.EMPTY_RESPONSE;
        }
        byte[] staticValue = dbCryptConfig.startsWith(BASE64_PREFIX) ? ByteArrayHelper.fromBase64String(dbCryptConfig.substring(7)) : dbCryptConfig.getBytes(StandardCharsets.UTF_8);
        return new StaticValueDbCryptCallback(staticValue);
    }
}

