/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.firebirdsql.gds.MessageLookup;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

final class MessageLoader {
    private static final String FIREBIRD_MESSAGES = "isc_error_msg";
    private static final String JAYBIRD_MESSAGES = "org/firebirdsql/jaybird_error_msg";
    private static final String FIREBIRD_SQLSTATES = "isc_error_sqlstates";
    private static final String JAYBIRD_SQLSTATES = "org/firebirdsql/jaybird_error_sqlstates";
    private final Logger log = LoggerFactory.getLogger(MessageLoader.class);
    private final List<Vector<String>> facilityMessages = MessageLoader.createFacilityVectorList();
    private final List<Vector<String>> facilityStates = MessageLoader.createFacilityVectorList();

    private MessageLoader() {
    }

    private static List<Vector<String>> createFacilityVectorList() {
        int size = 27;
        ArrayList<Vector<String>> vectors = new ArrayList<Vector<String>>(size);
        while (size-- > 0) {
            vectors.add(new Vector());
        }
        return vectors;
    }

    static MessageLookup loadErrorMessages() throws IOException {
        MessageLoader messageLoader = new MessageLoader();
        messageLoader.loadMessages(FIREBIRD_MESSAGES);
        messageLoader.loadMessages(JAYBIRD_MESSAGES);
        messageLoader.loadSqlStates(FIREBIRD_SQLSTATES);
        messageLoader.loadSqlStates(JAYBIRD_SQLSTATES);
        return messageLoader.createErrorLookup();
    }

    private MessageLookup createErrorLookup() {
        return new MessageLookup(this.facilityMessages, this.facilityStates);
    }

    private void loadMessages(String resource) throws IOException {
        this.loadResource(ResourceType.ERROR_MESSAGE, resource);
    }

    private void loadSqlStates(String resource) throws IOException {
        this.loadResource(ResourceType.SQL_STATE, resource);
    }

    private void loadResource(ResourceType resourceType, String resource) throws IOException {
        Properties properties = this.loadProperties(resource);
        this.mapToErrorCode(resourceType, properties);
    }

    private Properties loadProperties(String resource) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = MessageLoader.getResourceAsStream("/" + resource + ".properties");){
            if (in != null) {
                properties.load(in);
            } else {
                this.log.warn("Unable to load resource; resource " + resource + " is not found");
            }
        }
        catch (IOException ioex) {
            this.log.error("Unable to load resource " + resource, ioex);
            throw ioex;
        }
        return properties;
    }

    private void mapToErrorCode(ResourceType resourceType, Properties properties) {
        for (Object key : properties.keySet()) {
            if (!(key instanceof String)) continue;
            try {
                String keyString = (String)key;
                int errorCode = Integer.parseInt(keyString);
                String value = properties.getProperty(keyString);
                resourceType.store(errorCode, value, this);
            }
            catch (NumberFormatException e) {
                String message = "Key " + key + " is not a number; ignored";
                this.log.warn(message + "; see debug level for stacktrace");
                this.log.debug(message, e);
            }
        }
    }

    private void storeMessage(int errorCode, String value) {
        Vector<String> facilityMessage = this.facilityMessages.get(MessageLookup.getFacility(errorCode));
        this.storeValue(errorCode, value, facilityMessage);
    }

    private void storeSqlState(int errorCode, String value) {
        Vector<String> facilityState = this.facilityStates.get(MessageLookup.getFacility(errorCode));
        this.storeValue(errorCode, value.intern(), facilityState);
    }

    private void storeValue(int errorCode, String value, Vector<String> facilityVector) {
        if (facilityVector == null) {
            this.log.warn("Invalid error code " + errorCode + ", no valid facility; skipping");
            return;
        }
        int code = MessageLookup.getCode(errorCode);
        if (facilityVector.size() <= code) {
            facilityVector.setSize(code + 1);
        }
        facilityVector.set(code, value);
    }

    private static InputStream getResourceAsStream(String res) {
        InputStream in = MessageLoader.class.getResourceAsStream(res);
        if (in == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            in = cl.getResourceAsStream(res);
        }
        return in;
    }

    private static enum ResourceType {
        ERROR_MESSAGE{

            @Override
            void store(int errorCode, String value, MessageLoader messageLoader) {
                messageLoader.storeMessage(errorCode, value);
            }
        }
        ,
        SQL_STATE{

            @Override
            void store(int errorCode, String value, MessageLoader messageLoader) {
                messageLoader.storeSqlState(errorCode, value);
            }
        };


        abstract void store(int var1, String var2, MessageLoader var3);
    }
}

